package net.mehvahdjukaar.moonlight.core.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;


public class ClientBoundOpenScreenPacket implements Message {
    public final BlockPos pos;
    private final Direction dir;

    public ClientBoundOpenScreenPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.dir = Direction.m_122376_(buffer.m_130242_());
    }

    public ClientBoundOpenScreenPacket(BlockPos pos, Direction hitFace) {
        this.pos = pos;
        this.dir = hitFace;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.dir.m_122411_());
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        handleOpenScreenPacket(this);
    }

    @Environment(EnvType.CLIENT)
    public static void handleOpenScreenPacket(ClientBoundOpenScreenPacket message) {
        var level = Minecraft.m_91087_().f_91073_;
        var p = Minecraft.m_91087_().f_91074_;
        if (level != null && p != null) {
            BlockPos pos = message.pos;
            if (level.m_7702_(pos) instanceof IScreenProvider tile) {
                tile.openScreen(level, pos, p, message.dir);
            }
        }
    }


}