package net.mehvahdjukaar.moonlight.core.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

import java.util.Objects;
import java.util.UUID;

public class ClientBoundSpawnCustomEntityMessage implements Message {
    private final Entity entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final FriendlyByteBuf buf;

    public ClientBoundSpawnCustomEntityMessage(Entity e) {
        this.entity = e;
        this.typeId = BuiltInRegistries.f_256780_.m_7447_(e.m_6095_());
        this.entityId = e.m_19879_();
        this.uuid = e.m_20148_();
        this.posX = e.m_20185_();
        this.posY = e.m_20186_();
        this.posZ = e.m_20189_();
        this.pitch = (byte) Mth.m_14143_(e.m_146909_() * 256.0F / 360.0F);
        this.yaw = (byte) Mth.m_14143_(e.m_146908_() * 256.0F / 360.0F);
        this.headYaw = (byte) ((int) (e.m_6080_() * 256.0F / 360.0F));
        Vec3 vec3d = e.m_20184_();
        double d1 = Mth.m_14008_(vec3d.f_82479_, -3.9, 3.9);
        double d2 = Mth.m_14008_(vec3d.f_82480_, -3.9, 3.9);
        double d3 = Mth.m_14008_(vec3d.f_82481_, -3.9, 3.9);
        this.velX = (int) (d1 * 8000.0);
        this.velY = (int) (d2 * 8000.0);
        this.velZ = (int) (d3 * 8000.0);
        this.buf = null;

        //idk why this is needed but synced data fails to load correctly sometimes
        //TODO: remove and figure out why its needed

        //TODO: sent entity data drity here
    }

    public ClientBoundSpawnCustomEntityMessage(FriendlyByteBuf buf) {
        this.entity = null;
        this.typeId = buf.m_130242_();
        this.entityId = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
        this.headYaw = buf.readByte();
        this.velX = buf.readShort();
        this.velY = buf.readShort();
        this.velZ = buf.readShort();
        this.buf = new FriendlyByteBuf(buf.copy());
        buf.clear();
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130130_(this.typeId);
        buf.writeInt(this.entityId);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeByte(this.pitch);
        buf.writeByte(this.yaw);
        buf.writeByte(this.headYaw);
        buf.writeShort(this.velX);
        buf.writeShort(this.velY);
        buf.writeShort(this.velZ);
        if (this.entity instanceof IExtraClientSpawnData spawnData) {
            spawnData.writeSpawnData(buf);
        }

    }

    @Override
    public void handle(ChannelHandler.Context context) {
        EntityType<?> type = BuiltInRegistries.f_256780_.m_7942_(this.typeId);

        Level world = context.getSender().m_9236_();
        Entity e = type.m_20615_(world);
        if (e != null) {
            e.m_217006_(this.posX, this.posY, this.posZ);
            e.m_19890_(this.posX, this.posY, this.posZ, (this.yaw * 360) / 256.0F, (this.pitch * 360) / 256.0F);
            e.m_5616_((this.headYaw * 360) / 256.0F);
            e.m_5618_((this.headYaw * 360) / 256.0F);
            e.m_20234_(this.entityId);
            e.m_20084_(this.uuid);
            Objects.requireNonNull(ClientLevel.class);

            clientSideStuff(world, e);

            e.m_6001_(this.velX / 8000.0, this.velY / 8000.0, this.velZ / 8000.0);
            if (e instanceof IExtraClientSpawnData spawnData) {
                spawnData.readSpawnData(this.buf);
            }
        }
        this.buf.clear();
    }

    @Environment(EnvType.CLIENT)
    private void clientSideStuff(Level world, Entity e) {
        ((ClientLevel) world).m_104627_(this.entityId, e);

    }

}
