/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.AbstractCachedEditableResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.FastSearchPathPackResources;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_9224;
import org.apache.commons.io.FileUtils;

public class CachePathPackResources
extends AbstractCachedEditableResources {
    private final SafeWriter writer = new SafeWriter(this);

    public CachePathPackResources(class_9224 location, class_3264 type, Path path) {
        super(path, location, type, (class_2561)class_2561.method_43471((String)"message.moonlight.cached"));
    }

    @Override
    public void addResource(class_2960 id, byte[] bytes) {
        try {
            Path resPath = RPUtils.getResourcePath(this.path, id, this.packType);
            this.writer.writeFast(resPath, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeResource(class_2960 id) {
        Path resPath = RPUtils.getResourcePath(this.path, id, this.packType);
        try {
            CachePathPackResources.deleteRecursively(resPath);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to delete resource {}", (Object)id, (Object)e);
        }
    }

    @Override
    public void removeRootResource(String name) {
    }

    @Override
    public boolean clearAllResources() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.writer.clear();
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)this.path.toFile());
            } else {
                Files.deleteIfExists(this.path);
            }
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to clear cache pack resources at {}", (Object)this.path, (Object)e);
            return false;
        }
        Moonlight.LOGGER.info("Cleared cache pack resources at {} in {}", (Object)this.path, (Object)stopwatch);
        return true;
    }

    @Override
    public boolean initializeIfValid() {
        boolean dirExists;
        if (Files.exists(this.path, new LinkOption[0]) && !Files.isDirectory(this.path, new LinkOption[0])) {
            try {
                Files.delete(this.path);
            }
            catch (IOException e) {
                Moonlight.LOGGER.warn("Failed to remove invalid cache file at {}", (Object)this.path, (Object)e);
                return false;
            }
        }
        if (dirExists = Files.isDirectory(this.path, new LinkOption[0])) {
            this.cachedResources = CommonConfigs.FASTER_CACHE_SEARCH.get() != false ? new FastSearchPathPackResources(this.locationInfo, this.path, this.packType) : new class_3259.class_8619(this.path).method_52424(this.locationInfo);
        }
        return dirExists;
    }

    @Override
    public void commitChanges() {
        this.initializeIfValid();
    }

    @Override
    public class_3264 getPackType() {
        return this.packType;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private static void deleteRecursively(Path p) throws IOException {
        if (Files.isDirectory(p, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)p.toFile());
        } else {
            Files.deleteIfExists(p);
        }
    }

    private final class SafeWriter {
        private final Set<Path> dirCache = ConcurrentHashMap.newKeySet();

        private SafeWriter(CachePathPackResources cachePathPackResources) {
        }

        public void writeFast(Path filePath, byte[] bytes) throws IOException {
            Path normParent;
            Path parent = filePath.getParent();
            Path path = normParent = parent == null ? null : parent.toAbsolutePath().normalize();
            if (normParent != null && this.dirCache.add(normParent)) {
                Files.createDirectories(normParent, new FileAttribute[0]);
            }
            int attempts = 0;
            while (true) {
                try {
                    Files.write(filePath, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    return;
                }
                catch (NoSuchFileException e) {
                    if (normParent == null || ++attempts > 2) {
                        throw e;
                    }
                    Files.createDirectories(normParent, new FileAttribute[0]);
                    this.dirCache.add(normParent);
                    continue;
                }
                break;
            }
        }

        public void clear() {
            this.dirCache.clear();
        }
    }
}

