/*
 * Decompiled with CFR 0.152.
 */
package com.besson.arknights.block;

import com.besson.arknights.block.FurnitureHorizontalFacingBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ModDoubleBlock
extends FurnitureHorizontalFacingBlock {
    public static final EnumProperty<DoubleBlockType> TYPE = EnumProperty.m_61587_((String)"double_block_type", DoubleBlockType.class);

    public ModDoubleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)DoubleBlockType.SINGLE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{TYPE});
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pNeighborState.m_60713_((Block)this) && pDirection.m_122434_().m_122479_()) {
            DoubleBlockType doubleBlockType = (DoubleBlockType)((Object)pNeighborState.m_61143_(TYPE));
            if (pState.m_61143_(TYPE) == DoubleBlockType.SINGLE && doubleBlockType != DoubleBlockType.SINGLE && pState.m_61143_((Property)FACING) == pNeighborState.m_61143_((Property)FACING) && this.getFacing(pNeighborState) == pDirection.m_122424_()) {
                return (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)doubleBlockType.getOpposite()));
            }
        } else if (this.getFacing(pState) == pDirection) {
            return (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)DoubleBlockType.SINGLE));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    private Direction getFacing(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return state.m_61143_(TYPE) == DoubleBlockType.RIGHT ? direction.m_122427_() : direction.m_122428_();
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        DoubleBlockType doubleBlockType = DoubleBlockType.SINGLE;
        Direction direction = pContext.m_8125_().m_122424_();
        if (direction == this.getNeighborDirection(pContext, direction.m_122427_())) {
            doubleBlockType = DoubleBlockType.RIGHT;
        } else if (direction == this.getNeighborDirection(pContext, direction.m_122428_())) {
            doubleBlockType = DoubleBlockType.LEFT;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)((Object)doubleBlockType));
    }

    @Nullable
    public Direction getNeighborDirection(BlockPlaceContext pContext, Direction dir) {
        BlockState blockState = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(dir));
        return blockState.m_60713_((Block)this) && blockState.m_61143_(TYPE) == DoubleBlockType.SINGLE ? (Direction)blockState.m_61143_((Property)FACING) : null;
    }

    public static enum DoubleBlockType implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right");

        private final String id;

        private DoubleBlockType(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public DoubleBlockType getOpposite() {
            return switch (this) {
                case LEFT -> RIGHT;
                case RIGHT -> LEFT;
                default -> SINGLE;
            };
        }
    }
}

