/*
 * Decompiled with CFR 0.152.
 */
package com.besson.arknights.block.sideline;

import com.besson.arknights.block.FurnitureHorizontalFacingBlock;
import com.besson.arknights.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlackSimpleDesk
extends FurnitureHorizontalFacingBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlackSimpleDesk(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (world.m_5776_()) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos lbr = pos.m_121945_(dir.m_122428_());
        BlockPos ltl = pos.m_121945_(dir.m_122424_());
        BlockPos ltr = pos.m_121945_(dir.m_122424_()).m_121945_(dir.m_122428_());
        BlockPos rbl = lbr.m_121945_(dir.m_122428_());
        BlockPos rbr = rbl.m_121945_(dir.m_122428_());
        BlockPos rtl = ltr.m_121945_(dir.m_122428_());
        BlockPos rtr = rtl.m_121945_(dir.m_122428_());
        if (!this.canPlace(world, lbr, ltl, ltr, rbl, rbr, rtl, rtr)) {
            return;
        }
        world.m_7731_(lbr, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_LBR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(ltl, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_LTL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(ltr, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_LTR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(rbl, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_RBL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(rbr, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_RBR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(rtl, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_RTL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(rtr, (BlockState)((Block)ModBlocks.SIMPLE_BLACK_DESK_RTR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, moved);
            return;
        }
        BlockPos mainPos = this.findMainBlockPosition(state, pos);
        if (mainPos == null) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        this.removeAllParts(world, mainPos, dir);
        super.m_6810_(state, world, pos, newState, moved);
    }

    private void removeAllParts(Level world, BlockPos mainPos, Direction dir) {
        BlockPos[] partPositions;
        BlockPos lbr = mainPos.m_121945_(dir.m_122428_());
        BlockPos ltl = mainPos.m_121945_(dir.m_122424_());
        BlockPos ltr = mainPos.m_121945_(dir.m_122424_()).m_121945_(dir.m_122428_());
        BlockPos rbl = lbr.m_121945_(dir.m_122428_());
        BlockPos rbr = rbl.m_121945_(dir.m_122428_());
        BlockPos rtl = ltr.m_121945_(dir.m_122428_());
        BlockPos rtr = rtl.m_121945_(dir.m_122428_());
        for (BlockPos p : partPositions = new BlockPos[]{mainPos, lbr, ltl, ltr, rbl, rbr, rtl, rtr}) {
            if (!this.isDesk(world.m_8055_(p))) continue;
            world.m_7471_(p, false);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return null;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos lbr = pos.m_121945_(dir.m_122428_());
        BlockPos ltl = pos.m_121945_(dir.m_122424_());
        BlockPos ltr = pos.m_121945_(dir.m_122424_()).m_121945_(dir.m_122428_());
        BlockPos rbl = lbr.m_121945_(dir.m_122428_());
        BlockPos rbr = rbl.m_121945_(dir.m_122428_());
        BlockPos rtl = ltr.m_121945_(dir.m_122428_());
        BlockPos rtr = rtl.m_121945_(dir.m_122428_());
        boolean placeable = this.canPlace(world, lbr, ltl, ltr, rbl, rbr, rtl, rtr);
        return placeable ? state : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (neighborState.m_60795_()) {
            return state;
        }
        BlockPos mainPos = this.findMainBlockPosition(state, pos);
        if (mainPos != null && world.m_8055_(neighborPos).m_60795_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
    }

    private BlockPos findMainBlockPosition(BlockState state, BlockPos pos) {
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LBL.get())) {
            return pos;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LBR.get())) {
            return pos.m_121945_(dir.m_122427_());
        }
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LTL.get())) {
            return pos.m_121945_(dir);
        }
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LTR.get())) {
            return pos.m_121945_(dir.m_122427_()).m_121945_(dir);
        }
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RBL.get())) {
            return pos.m_5484_(dir.m_122427_(), 2);
        }
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RBR.get())) {
            return pos.m_5484_(dir.m_122427_(), 3);
        }
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RTL.get())) {
            return pos.m_5484_(dir.m_122427_(), 2).m_121945_(dir);
        }
        if (state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RTR.get())) {
            return pos.m_5484_(dir.m_122427_(), 3).m_121945_(dir);
        }
        return null;
    }

    private boolean canPlace(Level world, BlockPos ... pos) {
        for (BlockPos p : pos) {
            if (world.m_8055_(p).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private boolean isDesk(BlockState state) {
        return state.m_60713_((Block)this) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LBL.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LBR.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LTL.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_LTR.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RBL.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RBR.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RTL.get()) || state.m_60713_((Block)ModBlocks.SIMPLE_BLACK_DESK_RTR.get());
    }
}

