/*
 * Decompiled with CFR 0.152.
 */
package com.besson.arknights.block.sideline;

import com.besson.arknights.block.ModAbstractChestBlock;
import com.besson.arknights.block.ModBlocks;
import com.besson.arknights.block.sideline.CheckerboardBookcaseBE;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CheckerboardBookcase
extends ModAbstractChestBlock<CheckerboardBookcaseBE> {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public CheckerboardBookcase(BlockBehaviour.Properties settings, Supplier<BlockEntityType<? extends CheckerboardBookcaseBE>> blockEntityTypeSupplier) {
        super(settings, blockEntityTypeSupplier);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CheckerboardBookcaseBE(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (world.m_5776_()) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos bbr = pos.m_121945_(dir.m_122428_());
        BlockPos btl = pos.m_7494_();
        BlockPos btr = btl.m_121945_(dir.m_122428_());
        BlockPos mbl = btl.m_7494_();
        BlockPos mbr = mbl.m_121945_(dir.m_122428_());
        BlockPos mtl = mbl.m_7494_();
        BlockPos mtr = mtl.m_121945_(dir.m_122428_());
        BlockPos tl = mtl.m_7494_();
        BlockPos tr = tl.m_121945_(dir.m_122428_());
        if (!this.canPlace(world, bbr, btl, btr, mbl, mbr, mtl, mtr, tl, tr)) {
            return;
        }
        world.m_7731_(bbr, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BBR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(btl, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BTL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(btr, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BTR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(mbl, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MBL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(mbr, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MBR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(mtl, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MTL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(mtr, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MTR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(tl, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_TL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(tr, (BlockState)((Block)ModBlocks.CHECKERBOARD_BOOKCASE_TR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, moved);
            return;
        }
        BlockPos mainPos = this.findMainPos(state, pos);
        if (mainPos == null) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        this.removeAllParts(world, mainPos, dir);
        super.m_6810_(state, world, pos, newState, moved);
    }

    private void removeAllParts(Level world, BlockPos mainPos, Direction dir) {
        BlockPos[] pos;
        BlockPos bbr = mainPos.m_121945_(dir.m_122428_());
        BlockPos btl = mainPos.m_7494_();
        BlockPos btr = btl.m_121945_(dir.m_122428_());
        BlockPos mbl = btl.m_7494_();
        BlockPos mbr = mbl.m_121945_(dir.m_122428_());
        BlockPos mtl = mbl.m_7494_();
        BlockPos mtr = mtl.m_121945_(dir.m_122428_());
        BlockPos tl = mtl.m_7494_();
        BlockPos tr = tl.m_121945_(dir.m_122428_());
        for (BlockPos p : pos = new BlockPos[]{mainPos, bbr, btl, btr, mbl, mbr, mtl, mtr, tl, tr}) {
            if (!this.isBookcase(world.m_8055_(p))) continue;
            world.m_7471_(p, false);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return null;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos bbr = pos.m_121945_(dir.m_122428_());
        BlockPos btl = pos.m_7494_();
        BlockPos btr = btl.m_121945_(dir.m_122428_());
        BlockPos mbl = btl.m_7494_();
        BlockPos mbr = mbl.m_121945_(dir.m_122428_());
        BlockPos mtl = mbl.m_7494_();
        BlockPos mtr = mtl.m_121945_(dir.m_122428_());
        BlockPos tl = mtl.m_7494_();
        BlockPos tr = tl.m_121945_(dir.m_122428_());
        boolean placeable = this.canPlace(world, bbr, btl, btr, mbl, mbr, mtl, mtr, tl, tr);
        return placeable ? state : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122434_() == Direction.Axis.Y) {
            if (neighborState.m_60795_()) {
                return state;
            }
            BlockPos mainPos = this.findMainPos(state, pos);
            if (mainPos == null && world.m_8055_(neighborPos).m_60795_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private BlockPos findMainPos(BlockState state, BlockPos pos) {
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BBL.get())) {
            return pos;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BBR.get())) {
            return pos.m_121945_(dir.m_122427_());
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BTL.get())) {
            return pos.m_7495_();
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BTR.get())) {
            return pos.m_7495_().m_121945_(dir.m_122427_());
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MBL.get())) {
            return pos.m_6625_(2);
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MBR.get())) {
            return pos.m_6625_(2).m_121945_(dir.m_122427_());
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MTL.get())) {
            return pos.m_6625_(3);
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MTR.get())) {
            return pos.m_6625_(3).m_121945_(dir.m_122427_());
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_TL.get())) {
            return pos.m_6625_(4);
        }
        if (state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_TR.get())) {
            return pos.m_6625_(4).m_121945_(dir.m_122427_());
        }
        return null;
    }

    private boolean canPlace(Level world, BlockPos ... pos) {
        for (BlockPos p : pos) {
            if (world.m_8055_(p).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private boolean isBookcase(BlockState state) {
        return state.m_60713_((Block)this) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BBL.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BBR.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BTL.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_BTR.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MBL.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MBR.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MTL.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_MTR.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_TL.get()) || state.m_60713_((Block)ModBlocks.CHECKERBOARD_BOOKCASE_TR.get());
    }
}

