/*
 * Decompiled with CFR 0.152.
 */
package com.besson.arknights.block.sideline;

import com.besson.arknights.block.FurnitureHorizontalFacingBlock;
import com.besson.arknights.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GrayishWallTop
extends FurnitureHorizontalFacingBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public GrayishWallTop(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (world.m_5776_()) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos bbr = pos.m_121945_(dir.m_122428_());
        BlockPos btl = pos.m_7494_();
        BlockPos btr = pos.m_121945_(dir.m_122428_()).m_7494_();
        if (!this.canPlace(world, bbr, btl, btr)) {
            return;
        }
        world.m_7731_(bbr, (BlockState)((Block)ModBlocks.GRAYISH_WALL_TBR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(btl, (BlockState)((Block)ModBlocks.GRAYISH_WALL_TTL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
        world.m_7731_(btr, (BlockState)((Block)ModBlocks.GRAYISH_WALL_TTR.get()).m_49966_().m_61124_((Property)FACING, (Comparable)dir), 3);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, moved);
            return;
        }
        BlockPos mainPos = this.findMainBlockPosition(state, pos);
        if (mainPos == null) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        this.removeAllParts(world, mainPos, dir);
        super.m_6810_(state, world, pos, newState, moved);
    }

    private void removeAllParts(Level world, BlockPos mainPos, Direction dir) {
        BlockPos[] partPositions;
        for (BlockPos partPos : partPositions = new BlockPos[]{mainPos, mainPos.m_121945_(dir.m_122428_()), mainPos.m_7494_(), mainPos.m_121945_(dir.m_122428_()).m_7494_()}) {
            if (!this.isWallBottom(world.m_8055_(partPos))) continue;
            world.m_7471_(partPos, false);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return null;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos bbr = pos.m_121945_(dir.m_122428_());
        BlockPos btl = pos.m_7494_();
        BlockPos btr = pos.m_121945_(dir.m_122428_()).m_7494_();
        boolean placeable = this.canPlace(world, bbr, btl, btr);
        return placeable ? state : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122434_() == Direction.Axis.Y) {
            if (neighborState.m_60795_()) {
                return state;
            }
            BlockPos mainPos = this.findMainBlockPosition(state, pos);
            if (mainPos != null && this.isPartOfThisSet(mainPos, neighborPos, (Level)world) && world.m_8055_(neighborPos).m_60795_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean isPartOfThisSet(BlockPos mainPos, BlockPos pos, Level world) {
        BlockPos[] validPositions;
        Direction dir = (Direction)world.m_8055_(mainPos).m_61143_((Property)FACING);
        for (BlockPos validPos : validPositions = new BlockPos[]{mainPos, mainPos.m_121945_(dir.m_122428_()), mainPos.m_7494_(), mainPos.m_121945_(dir.m_122428_()).m_7494_()}) {
            if (!validPos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private BlockPos findMainBlockPosition(BlockState state, BlockPos pos) {
        if (state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TBL.get())) {
            return pos;
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TBR.get())) {
            return pos.m_121945_(dir.m_122427_());
        }
        if (state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TTL.get())) {
            return pos.m_7495_();
        }
        if (state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TTR.get())) {
            return pos.m_7495_().m_121945_(dir.m_122427_());
        }
        return null;
    }

    private boolean canPlace(Level world, BlockPos ... pos) {
        for (BlockPos blockPos : pos) {
            if (world.m_8055_(blockPos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private boolean isWallBottom(BlockState state) {
        return state.m_60713_((Block)this) || state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TBL.get()) || state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TBR.get()) || state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TTL.get()) || state.m_60713_((Block)ModBlocks.GRAYISH_WALL_TTR.get());
    }
}

