/*
 * Decompiled with CFR 0.152.
 */
package com.besson.arknights.block.warehouse;

import com.besson.arknights.block.ModAbstractChestBlock;
import com.besson.arknights.block.ModBlocks;
import com.besson.arknights.block.warehouse.LargeShelfBE;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LargeShelf
extends ModAbstractChestBlock<LargeShelfBE> {
    private static final VoxelShape SHAPE_NS = Block.m_49796_((double)-16.0, (double)0.0, (double)-4.0, (double)32.0, (double)16.0, (double)20.0);
    private static final VoxelShape SHAPE_WE = Block.m_49796_((double)-4.0, (double)0.0, (double)-16.0, (double)20.0, (double)16.0, (double)32.0);

    public LargeShelf(BlockBehaviour.Properties pProperties, Supplier<BlockEntityType<? extends LargeShelfBE>> pBlockEntityType) {
        super(pProperties, pBlockEntityType);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> SHAPE_WE;
            default -> SHAPE_NS;
        };
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.arknights.large_shelf"));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.m_5776_()) {
            return;
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockPos midPos1 = pPos.m_7494_();
        BlockPos midPos2 = pPos.m_6630_(2);
        BlockPos topPos = pPos.m_6630_(3);
        if (!this.canPlace(pLevel, midPos1, midPos2, topPos)) {
            return;
        }
        pLevel.m_7731_(midPos1, (BlockState)((Block)ModBlocks.LARGE_SHELF2.get()).m_49966_().m_61124_((Property)FACING, (Comparable)direction), 3);
        pLevel.m_7731_(midPos2, (BlockState)((Block)ModBlocks.LARGE_SHELF3.get()).m_49966_().m_61124_((Property)FACING, (Comparable)direction), 3);
        pLevel.m_7731_(topPos, (BlockState)((Block)ModBlocks.LARGE_SHELF4.get()).m_49966_().m_61124_((Property)FACING, (Comparable)direction), 3);
    }

    private boolean canPlace(Level pLevel, BlockPos ... pos) {
        for (BlockPos blockPos : pos) {
            if (pLevel.m_8055_(blockPos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        int i;
        if (pState.m_60713_(pNewState.m_60734_())) {
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
            return;
        }
        for (i = 1; i <= 3; ++i) {
            BlockPos upPos = pPos.m_6630_(i);
            if (!this.isShelfBlock(pLevel.m_8055_(upPos))) continue;
            pLevel.m_7471_(upPos, false);
        }
        for (i = 1; i <= 3; ++i) {
            BlockPos downPos = pPos.m_6625_(i);
            if (!this.isShelfBlock(pLevel.m_8055_(downPos))) continue;
            pLevel.m_7471_(downPos, false);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos mainPos = pContext.m_8083_();
        BlockState state = super.m_5573_(pContext);
        if (state == null) {
            return null;
        }
        BlockPos midPos1 = mainPos.m_7494_();
        BlockPos midPos2 = mainPos.m_6630_(2);
        BlockPos topPos = mainPos.m_6630_(3);
        boolean placeable = this.canPlace(level, midPos1, midPos2, topPos);
        return placeable ? state : null;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            if (pNeighborState.m_60795_()) {
                return pState;
            }
            if (this.isShelfBlock(pNeighborState) && pLevel.m_8055_(pNeighborPos).m_60795_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return (BlockState)pState.m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    private boolean isShelfBlock(BlockState state) {
        return state.m_60713_((Block)this) || state.m_60713_((Block)ModBlocks.LARGE_SHELF1.get()) || state.m_60713_((Block)ModBlocks.LARGE_SHELF2.get()) || state.m_60713_((Block)ModBlocks.LARGE_SHELF3.get()) || state.m_60713_((Block)ModBlocks.LARGE_SHELF4.get());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new LargeShelfBE(pPos, pState);
    }
}

