package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.models.LargeSignModel;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

import java.util.Random;

import static gollorum.signpost.minecraft.utils.CoordinatesUtil.FontToVoxelSize;
import static gollorum.signpost.minecraft.utils.CoordinatesUtil.VoxelSize;

public class LargeSignRenderer extends SignRenderer<LargeSignBlockPart> {

	private static final float TEXT_OFFSET_RIGHT = 7f * VoxelSize;
	private static final float TEXT_OFFSET_LEFT_SHORT = 9f * VoxelSize;
	private static final float TEXT_OFFSET_LEFT_LONG = 10f * VoxelSize;
	private static final float MAXIMUM_TEXT_WIDTH_SHORT = TEXT_OFFSET_RIGHT + TEXT_OFFSET_LEFT_SHORT;
	private static final float MAXIMUM_TEXT_WIDTH_LONG = TEXT_OFFSET_RIGHT + TEXT_OFFSET_LEFT_LONG;

	private static final float TEXT_RATIO = 1.3f;
	private static final float FONT_SIZE_VOXELS = 2 / TEXT_RATIO;

	@Override
	protected QuadModel makeMainModel(LargeSignBlockPart sign) {
		return (sign.isFlipped() ? LargeSignModel.MODEL_MAIN_FLIPPED : LargeSignModel.MODEL_MAIN);
	}

	@Override
	protected QuadModel makeSecondaryModel(LargeSignBlockPart sign) {
		return (sign.isFlipped() ? LargeSignModel.MODEL_SECONDARY_FLIPPED : LargeSignModel.MODEL_SECONDARY);
	}

	@Override
	protected QuadModel makeBakedOverlayModel(LargeSignBlockPart sign, Overlay overlay) {
		return (sign.isFlipped() ? LargeSignModel.MODEL_OVERLAY_FLIPPED : LargeSignModel.MODEL_OVERLAY);
	}

	@Override
	public void renderText(LargeSignBlockPart sign, PoseStack matrix, Font fontRenderer, SubmitNodeCollector nodeCollector, int combinedLights) {
		RenderingUtil.wrapInMatrixEntry(matrix, () -> {
			matrix.translate(0, 3.5f * VoxelSize, -3.005 * VoxelSize);

			RenderingUtil.wrapInMatrixEntry(matrix, () -> render(sign, fontRenderer, sign.getText()[3].get(), matrix, nodeCollector, combinedLights, false));
			matrix.translate(0, -7 / 3f * VoxelSize, 0);

			RenderingUtil.wrapInMatrixEntry(matrix, () -> render(sign, fontRenderer, sign.getText()[2].get(), matrix, nodeCollector, combinedLights, false));
			matrix.translate(0, -7 / 3f * VoxelSize, 0);

			RenderingUtil.wrapInMatrixEntry(matrix, () -> render(sign, fontRenderer, sign.getText()[1].get(), matrix, nodeCollector, combinedLights, false));
			matrix.translate(0, -7 / 3f * VoxelSize, 0);

			RenderingUtil.wrapInMatrixEntry(matrix, () -> render(sign, fontRenderer, sign.getText()[0].get(), matrix, nodeCollector, combinedLights, false));
		});
	}

	private void render(LargeSignBlockPart sign, Font fontRenderer, String txt, PoseStack matrix, SubmitNodeCollector nodeCollector, int combinedLights, boolean isLong) {
		RenderingUtil.wrapInMatrixEntry(matrix, () -> {
			var text = txt;
			if(sign.isMarkedForGeneration()) {
				var overrideName = WaystoneLibrary.getInstance().getAllWaystoneNames(true)
					.flatMap(s -> s.stream().skip(new Random().nextInt(s.size() - 1)).findFirst());
				if(overrideName.isPresent()) text = overrideName.get();
			}
			float scale = FONT_SIZE_VOXELS * FontToVoxelSize;
			float MAX_WIDTH_FRAC = fontRenderer.width(text) * scale / (isLong ? MAXIMUM_TEXT_WIDTH_LONG : MAXIMUM_TEXT_WIDTH_SHORT);
			scale /= Math.max(1, MAX_WIDTH_FRAC);
			float offset = TEXT_OFFSET_RIGHT * Math.min(1, MAX_WIDTH_FRAC);
			matrix.translate(
				sign.isFlipped() ? offset - fontRenderer.width(text) * scale : -offset,
				-scale * 4 * TEXT_RATIO,
				0
			);
			matrix.scale(scale, scale * TEXT_RATIO, scale);

            nodeCollector.submitText(
                matrix, 0, 0,
                Component.literal(text).getVisualOrderText(),
                false,
                Font.DisplayMode.POLYGON_OFFSET,
                combinedLights,
                Colors.withAlpha(sign.getColor(), 0xff),
                0,
                0
            );
		});
	}

}
