package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ModelButton extends SignpostImageButton {

    private final List<GuiModelRenderer> modelRenderers;

    private final TextureResource background;

    public ModelButton(
        TextureResource background,
        Point point,
        float scale,
        Rect.XAlignment xAlignment,
        Rect.YAlignment yAlignment,
        Function<Rect, Rect> rectBuilder,
        Runnable onPress,
        ModelData... modelData
    ) {
        this(
            background,
            new Rect(point, background.size.scale(scale), xAlignment, yAlignment),
            scale, rectBuilder, b -> onPress.run(), modelData
        );
    }

    private ModelButton(
        TextureResource background,
        Rect rect,
        float scale,
        Function<Rect, Rect> rectBuilder,
        Button.OnPress onPress,
        ModelData... modelData
    ){
        super(
            background,
            rect,
            onPress
        );
        this.background = background;
        modelRenderers = new ArrayList<>();
        for(ModelData model: modelData) {
            modelRenderers.add(new GuiModelRenderer(
                rectBuilder.apply(rect),
                model.model,
                model.modelSpaceXOffset,
                model.modelSpaceYOffset));
        }
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        for(GuiModelRenderer model : modelRenderers) {
            model.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public static class ModelData {

        public final FlippableModel model;
        public final float modelSpaceXOffset;
        public final float modelSpaceYOffset;
        public final ItemStack itemStack;

        public ModelData(FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, ItemStack itemStack) {
            this.model = model;
            this.modelSpaceXOffset = modelSpaceXOffset;
            this.modelSpaceYOffset = modelSpaceYOffset;
            this.itemStack = itemStack;
        }

    }

}
