/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.addon.misc;

import com.magistuarmory.addon.item.AddonItems;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;

public class AddonCreativeTabs {
    public static final ResourceKey<CreativeModeTab> PARTICULAR_WEAPONS_RESOURCE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("magistuarmory", "particular_weapons"));
    public static final ResourceKey<CreativeModeTab> ARMOR_RESOURCE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("magistuarmory", "armor"));
    public static final ResourceKey<CreativeModeTab> ARMOR_DECORATIONS_RESOURCE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("magistuarmory", "armor_decorations"));
    public static final ResourceKey<CreativeModeTab> INGREDIENTS_RESOURCE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)CreativeModeTabs.f_256968_.m_135782_());

    public static void init() {
        for (RegistrySupplier item : AddonItems.INSTANCE.weaponItems) {
            AddonCreativeTabs.append(PARTICULAR_WEAPONS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.armorItems) {
            AddonCreativeTabs.append(ARMOR_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.armorDecorationItems) {
            AddonCreativeTabs.append(ARMOR_DECORATIONS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        for (RegistrySupplier item : AddonItems.INSTANCE.ingredientItems) {
            AddonCreativeTabs.append(INGREDIENTS_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{item});
        }
        AddonCreativeTabs.append(ARMOR_RESOURCE_KEY, (Supplier[])new RegistrySupplier[]{AddonItems.DARK_BARDING});
    }

    @SafeVarargs
    public static <I extends ItemLike, T extends Supplier<I>> void append(ResourceKey<CreativeModeTab> tab, T ... items) {
        Arrays.stream(items).filter(Objects::nonNull).forEach(item -> CreativeTabRegistry.append((ResourceKey)tab, (Supplier[])new Supplier[]{item}));
    }
}

