/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.birds;

import dev.hybridlabs.birds.Constants;
import dev.hybridlabs.birds.config.HybridBirdsConfig;
import dev.hybridlabs.birds.config.HybridBirdsConfigHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljava/nio/file/Path;", "configFile", "Ldev/hybridlabs/birds/config/HybridBirdsConfigHandler;", "configHandler", "", "initializeConfig", "(Ljava/nio/file/Path;Ldev/hybridlabs/birds/config/HybridBirdsConfigHandler;)V", "hybrid-birds-fabric-1.20.1"})
public final class ConfigHelperKt {
    public static final void initializeConfig(@NotNull Path configFile, @NotNull HybridBirdsConfigHandler configHandler) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        Intrinsics.checkNotNullParameter((Object)configHandler, (String)"configHandler");
        Logger logger = Constants.LOG;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Hybrid Birds config file did not exist, creating one");
            configHandler.save();
        } else {
            logger.info("Loading Hybrid Birds config file");
            configHandler.load();
            HybridBirdsConfig defaultConfig = configHandler.getDefaultConfig();
            HybridBirdsConfig config = configHandler.getConfig();
            if (config.getDataVersion() < defaultConfig.getDataVersion()) {
                logger.info("Old Hybrid Birds config file found, upgrading");
                configHandler.backup();
                configHandler.setConfig(defaultConfig);
                configHandler.save();
                logger.info("Hybrid Birds config reset, the old config has been backed up to \"" + configHandler.getBackupFile() + "\"");
            }
        }
    }

    public static /* synthetic */ void initializeConfig$default(Path path, HybridBirdsConfigHandler hybridBirdsConfigHandler, int n, Object object) {
        if ((n & 1) != 0) {
            path = Constants.CONFIG_FILE;
        }
        ConfigHelperKt.initializeConfig(path, hybridBirdsConfigHandler);
    }
}

