/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.birds;

import dev.hybridlabs.birds.ConfigHelperKt;
import dev.hybridlabs.birds.Constants;
import dev.hybridlabs.birds.config.EntitySpawnConfig;
import dev.hybridlabs.birds.config.HybridBirdsConfig;
import dev.hybridlabs.birds.config.HybridBirdsConfigHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1311;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/hybridlabs/birds/HybridBirds;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Ldev/hybridlabs/birds/config/HybridBirdsConfig;", "config", "registerBiomeModifications", "(Ldev/hybridlabs/birds/config/HybridBirdsConfig;)V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "hybrid-birds-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHybridBirds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridBirds.kt\ndev/hybridlabs/birds/HybridBirds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1869#2,2:59\n*S KotlinDebug\n*F\n+ 1 HybridBirds.kt\ndev/hybridlabs/birds/HybridBirds\n*L\n53#1:59,2\n*E\n"})
public final class HybridBirds
implements ModInitializer {
    @NotNull
    public static final HybridBirds INSTANCE = new HybridBirds();
    @NotNull
    private static final Logger logger;

    private HybridBirds() {
    }

    public void onInitialize() {
        logger.info("Initializing Hybrid Birds");
        Path configFile = Constants.CONFIG_FILE;
        File file = configFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        HybridBirdsConfigHandler configHandler = new HybridBirdsConfigHandler(file, null, 2, null);
        Intrinsics.checkNotNull((Object)configFile);
        ConfigHelperKt.initializeConfig(configFile, configHandler);
        this.registerBiomeModifications(configHandler.getConfig());
    }

    private final void registerBiomeModifications(HybridBirdsConfig config) {
        Iterable $this$forEach$iv = config.getEntitySpawnConfig();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntitySpawnConfig config2 = (EntitySpawnConfig)element$iv;
            boolean bl = false;
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.tag(config2.getBiomes()), (class_1311)config2.getGroup(), config2.getType(), (int)config2.getWeight(), (int)config2.getMinGroupSize(), (int)config2.getMaxGroupSize());
        }
    }

    static {
        Logger logger = Constants.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
        HybridBirds.logger = logger;
    }
}

