/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.birds.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.hybridlabs.birds.config.HybridBirdsConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\r\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0019\u0010\u0014R\"\u0010\u001a\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Ldev/hybridlabs/birds/config/HybridBirdsConfigHandler;", "", "Ljava/io/File;", "file", "Ldev/hybridlabs/birds/config/HybridBirdsConfig;", "defaultConfig", "<init>", "(Ljava/io/File;Ldev/hybridlabs/birds/config/HybridBirdsConfig;)V", "Lcom/mojang/serialization/DataResult;", "Lcom/mojang/datafixers/util/Pair;", "Lcom/google/gson/JsonElement;", "read", "()Lcom/mojang/serialization/DataResult;", "", "load", "()Z", "save", "backup", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "Ldev/hybridlabs/birds/config/HybridBirdsConfig;", "getDefaultConfig", "()Ldev/hybridlabs/birds/config/HybridBirdsConfig;", "backupFile", "getBackupFile", "config", "getConfig", "setConfig", "(Ldev/hybridlabs/birds/config/HybridBirdsConfig;)V", "Companion", "hybrid-birds-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHybridBirdsConfigHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridBirdsConfigHandler.kt\ndev/hybridlabs/birds/config/HybridBirdsConfigHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class HybridBirdsConfigHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final HybridBirdsConfig defaultConfig;
    @NotNull
    private final File backupFile;
    @NotNull
    private HybridBirdsConfig config;
    @NotNull
    private static final Gson GSON;

    public HybridBirdsConfigHandler(@NotNull File file, @NotNull HybridBirdsConfig defaultConfig) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        this.file = file;
        this.defaultConfig = defaultConfig;
        File file2 = this.file.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        this.backupFile = FilesKt.resolve((File)file2, (String)(this.file.getName() + "-backup"));
        this.config = this.defaultConfig;
    }

    public /* synthetic */ HybridBirdsConfigHandler(File file, HybridBirdsConfig hybridBirdsConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            hybridBirdsConfig = new HybridBirdsConfig(0, null, 3, null);
        }
        this(file, hybridBirdsConfig);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final HybridBirdsConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @NotNull
    public final File getBackupFile() {
        return this.backupFile;
    }

    @NotNull
    public final HybridBirdsConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull HybridBirdsConfig hybridBirdsConfig) {
        Intrinsics.checkNotNullParameter((Object)hybridBirdsConfig, (String)"<set-?>");
        this.config = hybridBirdsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DataResult<Pair<HybridBirdsConfig, JsonElement>> read() {
        JsonElement jsonElement;
        Object object = this.file;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            Reader p0 = (Reader)object;
            boolean bl = false;
            jsonElement = JsonParser.parseReader((Reader)p0);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        JsonElement json = jsonElement;
        DataResult dataResult = HybridBirdsConfig.Companion.getCODEC().decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"decode(...)");
        return dataResult;
    }

    public final boolean load() {
        DataResult<Pair<HybridBirdsConfig, JsonElement>> dataResult = this.read();
        Optional result = dataResult.result();
        if (!result.isPresent()) {
            return false;
        }
        Object object = ((Pair)result.get()).getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
        this.config = (HybridBirdsConfig)object;
        return true;
    }

    public final boolean save() {
        DataResult dataResult = HybridBirdsConfig.Companion.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.config);
        Optional result = dataResult.result();
        if (!result.isPresent()) {
            return false;
        }
        Object t = result.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        JsonElement json = (JsonElement)t;
        String text = GSON.toJson(json);
        Intrinsics.checkNotNull((Object)text);
        FilesKt.writeText$default((File)this.file, (String)text, null, (int)2, null);
        return true;
    }

    public final boolean backup() {
        Object object;
        Object object2 = this;
        try {
            HybridBirdsConfigHandler $this$backup_u24lambda_u240 = object2;
            boolean bl = false;
            FilesKt.writeBytes((File)$this$backup_u24lambda_u240.backupFile, (byte[])FilesKt.readBytes((File)$this$backup_u24lambda_u240.file));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Result.isFailure-impl((Object)object2) ? null : object2) != null;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/hybridlabs/birds/config/HybridBirdsConfigHandler$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "hybrid-birds-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

