/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.items;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.layout.items.Executable;
import team.bytephoria.layout.items.ItemLayoutBase;
import team.bytephoria.layout.items.builder.ItemBuilderBase;
import team.bytephoria.layout.items.builder.ItemBuilderClickable;
import team.bytephoria.layout.items.context.InventoryClickContext;

public class ClickableItemLayout
extends ItemLayoutBase
implements Executable {
    protected final EnumMap<ClickType, Consumer<InventoryClickContext>> clickActions;

    public ClickableItemLayout(@Nullable Component displayName, @Nullable List<Component> lore, @NotNull Material material, int amount, @Nullable Integer customModelData, @NotNull EnumMap<ClickType, Consumer<InventoryClickContext>> clickActions) {
        super(displayName, lore, material, amount, customModelData);
        this.clickActions = clickActions;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder of(@NotNull Material material) {
        return new Builder(material);
    }

    @NotNull
    public static Builder of(@NotNull ItemStack itemStack) {
        return ItemBuilderBase.fromItemStack(new Builder(), itemStack);
    }

    @Override
    public void execute(@NotNull InventoryClickContext context) {
        Consumer<InventoryClickContext> consumer = this.clickActions.get(context.clickEvent().getClick());
        if (consumer != null) {
            consumer.accept(context);
        }
    }

    public static class Builder
    extends ItemBuilderClickable<Builder, ClickableItemLayout> {
        public Builder() {
        }

        public Builder(@NotNull Material material) {
            this.material = material;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClickableItemLayout build() {
            return new ClickableItemLayout(this.displayName, this.lore, this.material, this.amount, this.customModelData, this.clickActions);
        }
    }
}

