/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.items;

import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.items.ItemLayoutBase;
import team.bytephoria.layout.items.builder.ItemBuilderBase;

public class ItemLayout
extends ItemLayoutBase {
    public ItemLayout(Component displayName, List<Component> lore, Material material, int amount, Integer customModelData) {
        super(displayName, lore, material, amount, customModelData);
    }

    @NotNull
    public static ItemLayout display(@NotNull Material material) {
        return new Builder(material).build();
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder of(@NotNull Material material) {
        return new Builder(material);
    }

    @NotNull
    public static Builder of(@NotNull ItemStack itemStack) {
        return ItemBuilderBase.fromItemStack(new Builder(), itemStack);
    }

    public static class Builder
    extends ItemBuilderBase<Builder, ItemLayout> {
        public Builder() {
        }

        public Builder(@NotNull Material material) {
            this.material = material;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ItemLayout build() {
            return new ItemLayout(this.displayName, this.lore, this.material, this.amount, this.customModelData);
        }
    }
}

