/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.items;

import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.common.Builder;

public abstract class ItemLayoutBase
implements Builder<ItemStack> {
    protected final Component displayName;
    protected final List<Component> lore;
    protected final Material material;
    protected final int amount;
    protected final Integer customModelData;

    public ItemLayoutBase(Component displayName, List<Component> lore, Material material, int amount, Integer customModelData) {
        this.displayName = displayName;
        this.lore = lore;
        this.material = material;
        this.amount = Math.min(Math.max(1, amount), 64);
        this.customModelData = customModelData;
    }

    public Component displayName() {
        return this.displayName;
    }

    public List<Component> lore() {
        return this.lore;
    }

    public Material material() {
        return this.material;
    }

    public int amount() {
        return this.amount;
    }

    public Integer customModelData() {
        return this.customModelData;
    }

    @Override
    @NotNull
    public final ItemStack build() {
        ItemStack itemStack = new ItemStack(this.material, this.amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (this.displayName != null) {
            itemMeta.displayName(this.displayName);
        }
        if (this.lore != null) {
            itemMeta.lore(this.lore);
        }
        itemMeta.setCustomModelData(this.customModelData);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

