/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.items.builder;

import java.util.EnumMap;
import java.util.function.Consumer;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.items.ClickableItemLayout;
import team.bytephoria.layout.items.builder.ItemBuilderBase;
import team.bytephoria.layout.items.context.InventoryClickContext;

public abstract class ItemBuilderClickable<B extends ItemBuilderClickable<B, T>, T extends ClickableItemLayout>
extends ItemBuilderBase<B, T> {
    protected final EnumMap<ClickType, Consumer<InventoryClickContext>> clickActions = new EnumMap(ClickType.class);

    public B onMiddleClick(@NotNull Consumer<InventoryClickContext> clickContextConsumer) {
        return this.onClick(ClickType.MIDDLE, clickContextConsumer);
    }

    public B onDropClick(@NotNull Consumer<InventoryClickContext> clickContextConsumer) {
        return this.onClick(ClickType.DROP, clickContextConsumer);
    }

    public B onLeftClick(@NotNull Consumer<InventoryClickContext> clickContextConsumer) {
        return this.onClick(ClickType.LEFT, clickContextConsumer);
    }

    public B onRightClick(@NotNull Consumer<InventoryClickContext> clickContextConsumer) {
        return this.onClick(ClickType.RIGHT, clickContextConsumer);
    }

    public B onClick(@NotNull ClickType clickType, @NotNull Consumer<InventoryClickContext> consumer) {
        this.clickActions.put(clickType, consumer);
        return (B)((ItemBuilderClickable)this.self());
    }
}

