/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.layouts.base;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.items.Executable;
import team.bytephoria.layout.items.ItemLayoutBase;
import team.bytephoria.layout.items.context.InventoryClickContext;
import team.bytephoria.layout.layouts.InventoryListener;
import team.bytephoria.layout.layouts.Layout;
import team.bytephoria.layout.layouts.base.InventoryHolderBase;
import team.bytephoria.layout.layouts.behavior.LayoutBehavior;
import team.bytephoria.layout.layouts.context.InventoryCloseContext;
import team.bytephoria.layout.layouts.context.InventoryOpenContext;

public class LayoutInventoryBase
extends InventoryHolderBase
implements Layout,
InventoryListener {
    protected final Int2ObjectArrayMap<ItemLayoutBase> itemLayouts;
    protected final LayoutBehavior layoutBehavior;

    protected LayoutInventoryBase(@NotNull LayoutBehavior layoutBehavior, @NotNull Int2ObjectArrayMap<ItemLayoutBase> itemLayouts, @NotNull Component title, int size) {
        super(title, size);
        this.itemLayouts = itemLayouts;
        this.layoutBehavior = layoutBehavior;
    }

    protected LayoutInventoryBase(@NotNull LayoutBehavior layoutBehavior, @NotNull Int2ObjectArrayMap<ItemLayoutBase> itemLayouts, @NotNull InventoryType type, @NotNull Component title) {
        super(type, title);
        this.itemLayouts = itemLayouts;
        this.layoutBehavior = layoutBehavior;
    }

    @Override
    public void onInventoryClick(@NotNull InventoryClickEvent clickEvent) {
        Inventory clickedInventory;
        ItemStack currentItemStack = clickEvent.getCurrentItem();
        ItemStack cursorItemStack = clickEvent.getCursor();
        if (currentItemStack == null && this.layoutBehavior.ignoreEmptySlots() && (cursorItemStack == null || cursorItemStack.getType() == Material.AIR)) {
            return;
        }
        if (this.layoutBehavior.cancelAllClicks()) {
            clickEvent.setCancelled(true);
        }
        if ((clickedInventory = clickEvent.getClickedInventory()) == null) {
            return;
        }
        InventoryType inventoryType = clickedInventory.getType();
        if (inventoryType == InventoryType.PLAYER) {
            if (this.layoutBehavior.allowPlayerInventoryClicks()) {
                return;
            }
            return;
        }
        if (this.layoutBehavior.cancelLayoutClicks()) {
            clickEvent.setCancelled(true);
        }
        Player player = (Player)clickEvent.getWhoClicked();
        InventoryClickContext inventoryClickContext = new InventoryClickContext(player, clickEvent);
        int clickedSlot = clickEvent.getSlot();
        ItemLayoutBase itemLayoutBase = (ItemLayoutBase)this.itemLayouts.get(clickedSlot);
        if (itemLayoutBase instanceof Executable) {
            Executable executable = (Executable)((Object)itemLayoutBase);
            executable.execute(inventoryClickContext);
        }
        if (this.layoutBehavior.closeOnClick()) {
            clickEvent.getWhoClicked().closeInventory();
        }
        this.layoutBehavior.onClick().accept(inventoryClickContext);
    }

    @Override
    public void onInventoryOpen(@NotNull InventoryOpenEvent openEvent) {
        Player player = (Player)openEvent.getPlayer();
        this.layoutBehavior.onOpen().accept(new InventoryOpenContext(player));
    }

    @Override
    public void onInventoryClose(@NotNull InventoryCloseEvent closeEvent) {
        Player player = (Player)closeEvent.getPlayer();
        this.layoutBehavior.onClose().accept(new InventoryCloseContext(player, closeEvent.getReason()));
    }

    private void item(int slot, @NotNull ItemStack itemStack) {
        this.getInventory().setItem(slot, itemStack);
    }

    @Override
    public void item(int slot, @NotNull ItemLayoutBase itemLayout) {
        this.item(slot, itemLayout.build());
    }

    @Override
    public void fill(@NotNull ItemLayoutBase itemLayout) {
        ItemStack itemStack = itemLayout.build();
        for (int slot = 0; slot < super.slots(); ++slot) {
            this.item(slot, itemStack);
        }
    }

    @Override
    public void fillRange(int from, int to, @NotNull ItemLayoutBase itemLayout) {
        ItemStack itemStack = itemLayout.build();
        for (int slot = from; slot < to; ++slot) {
            this.item(slot, itemStack);
        }
    }

    @Override
    public void update(int slot) {
        ItemLayoutBase itemLayoutBase = (ItemLayoutBase)this.itemLayouts.get(slot);
        if (itemLayoutBase != null) {
            this.item(slot, itemLayoutBase.build());
        }
    }

    @Override
    public void open(@NotNull Player player) {
        this.itemLayouts.forEach(this::item);
        player.openInventory(this.getInventory());
    }

    @NotNull
    public LayoutBehavior layoutBehavior() {
        return this.layoutBehavior;
    }

    @Override
    public void open(Player ... players) {
        for (Player player : players) {
            player.openInventory(this.getInventory());
        }
    }
}

