/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.layouts.behavior;

import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.common.Builder;
import team.bytephoria.layout.items.context.InventoryClickContext;
import team.bytephoria.layout.layouts.behavior.LayoutBehavior;
import team.bytephoria.layout.layouts.context.InventoryCloseContext;
import team.bytephoria.layout.layouts.context.InventoryOpenContext;

public final class LayoutBehaviorBuilder
implements Builder<LayoutBehavior> {
    private boolean closeOnClick = false;
    private boolean cancelAllClicks = false;
    private boolean cancelLayoutClicks = true;
    private boolean allowPlayerInventoryClicks = true;
    private boolean ignoreEmptySlotClicks = false;
    private Consumer<InventoryOpenContext> onOpen = inventoryOpenContext -> {};
    private Consumer<InventoryCloseContext> onClose = inventoryCloseContext -> {};
    private Consumer<InventoryClickContext> onClick = clickContext -> {};

    public LayoutBehaviorBuilder closeOnClick(boolean closeOnClick) {
        this.closeOnClick = closeOnClick;
        return this;
    }

    public LayoutBehaviorBuilder cancelAllClicks(boolean cancelAllClicks) {
        this.cancelAllClicks = cancelAllClicks;
        return this;
    }

    public LayoutBehaviorBuilder cancelLayoutClicks(boolean cancelLayoutClicks) {
        this.cancelLayoutClicks = cancelLayoutClicks;
        return this;
    }

    public LayoutBehaviorBuilder allowPlayerInventoryClicks(boolean allowPlayerInventoryClicks) {
        this.allowPlayerInventoryClicks = allowPlayerInventoryClicks;
        return this;
    }

    public LayoutBehaviorBuilder ignoreEmptySlots(boolean ignoreEmptySlots) {
        this.ignoreEmptySlotClicks = ignoreEmptySlots;
        return this;
    }

    public LayoutBehaviorBuilder onOpen(@NotNull Consumer<InventoryOpenContext> consumer) {
        this.onOpen = consumer;
        return this;
    }

    public LayoutBehaviorBuilder onClose(@NotNull Consumer<InventoryCloseContext> consumer) {
        this.onClose = consumer;
        return this;
    }

    public LayoutBehaviorBuilder onClick(@NotNull Consumer<InventoryClickContext> consumer) {
        this.onClick = consumer;
        return this;
    }

    @Override
    @Contract(value=" -> new")
    @NotNull
    public LayoutBehavior build() {
        return new LayoutBehavior(this.closeOnClick, this.cancelAllClicks, this.cancelLayoutClicks, this.allowPlayerInventoryClicks, this.ignoreEmptySlotClicks, this.onOpen, this.onClose, this.onClick);
    }
}

