/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.layouts.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.layout.common.Builder;
import team.bytephoria.layout.items.ItemLayoutBase;
import team.bytephoria.layout.layouts.base.InventoryHolderBase;
import team.bytephoria.layout.layouts.behavior.LayoutBehavior;
import team.bytephoria.layout.layouts.behavior.LayoutBehaviorBuilder;

public abstract class AbstractLayoutBuilder<B extends AbstractLayoutBuilder<B, O>, O extends InventoryHolderBase>
implements Builder<O> {
    protected Component title;
    protected Int2ObjectArrayMap<ItemLayoutBase> itemLayouts = new Int2ObjectArrayMap();
    protected LayoutBehavior layoutBehavior = LayoutBehavior.builder().build();

    protected abstract B self();

    public B title(@Nullable Component title) {
        this.title = title != null ? title : Component.empty();
        return this.self();
    }

    public B item(int slot, @NotNull ItemLayoutBase itemLayout) {
        this.itemLayouts.put(slot, (Object)itemLayout);
        return this.self();
    }

    public B range(int from, int to, @NotNull ItemLayoutBase itemLayout) {
        for (int index = from; index < to; ++index) {
            this.itemLayouts.put(index, (Object)itemLayout);
        }
        return this.self();
    }

    public abstract B fillAll(@NotNull ItemLayoutBase var1);

    public B behavior(@NotNull Consumer<LayoutBehaviorBuilder> layoutBehaviorBuilderConsumer) {
        LayoutBehaviorBuilder behaviorBuilder = LayoutBehavior.builder();
        layoutBehaviorBuilderConsumer.accept(behaviorBuilder);
        this.layoutBehavior = behaviorBuilder.build();
        return this.self();
    }

    public B editBehavior(@NotNull Consumer<LayoutBehaviorBuilder> layoutBehaviorBuilderConsumer) {
        LayoutBehaviorBuilder layoutBehaviorBuilder = LayoutBehavior.builder().closeOnClick(this.layoutBehavior.closeOnClick()).cancelLayoutClicks(this.layoutBehavior.cancelLayoutClicks()).allowPlayerInventoryClicks(this.layoutBehavior.allowPlayerInventoryClicks()).ignoreEmptySlots(this.layoutBehavior.ignoreEmptySlots()).onOpen(this.layoutBehavior.onOpen()).onClose(this.layoutBehavior.onClose()).onClick(this.layoutBehavior.onClick());
        layoutBehaviorBuilderConsumer.accept(layoutBehaviorBuilder);
        this.layoutBehavior = layoutBehaviorBuilder.build();
        return this.self();
    }

    public B behavior(@NotNull Supplier<LayoutBehavior> layoutBehaviorBuilderSupplier) {
        this.layoutBehavior = layoutBehaviorBuilderSupplier.get();
        return this.self();
    }
}

