/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.layouts.builder.sized;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.common.Builder;
import team.bytephoria.layout.items.ItemLayout;

public final class PatternLayoutBuilder
implements Builder<Int2ObjectArrayMap<ItemLayout>> {
    private final Int2ObjectArrayMap<ItemLayout> layoutItems = new Int2ObjectArrayMap();
    private final Char2ObjectArrayMap<ItemLayout> keyMap = new Char2ObjectArrayMap();
    private String[] patternLines = new String[0];
    private int size = 1;

    private PatternLayoutBuilder() {
    }

    @Contract(value=" -> new")
    @NotNull
    public static PatternLayoutBuilder builder() {
        return new PatternLayoutBuilder();
    }

    public PatternLayoutBuilder pattern(String ... patternLines) {
        this.patternLines = this.formatPattern(patternLines);
        return this;
    }

    public PatternLayoutBuilder item(int slot, @NotNull ItemLayout itemLayout) {
        this.layoutItems.put(slot, (Object)itemLayout);
        return this;
    }

    @NotNull
    private @NotNull String @NotNull [] formatPattern(String ... patternLines) {
        int adjustedLength;
        if (patternLines.length == 0) {
            return new String[0];
        }
        this.size = adjustedLength = Math.min(patternLines.length, 6);
        return Arrays.copyOf(patternLines, adjustedLength);
    }

    public PatternLayoutBuilder key(char key, @NotNull ItemLayout itemLayout) {
        this.keyMap.put(key, (Object)itemLayout);
        return this;
    }

    public int size() {
        return this.size * 9;
    }

    @Override
    @NotNull
    public Int2ObjectArrayMap<ItemLayout> build() {
        int rowIndex = 0;
        for (String patternLine : this.patternLines) {
            int baseIndex = rowIndex * 9;
            for (int columnIndex = 0; columnIndex < patternLine.length(); ++columnIndex) {
                ItemLayout layout = (ItemLayout)this.keyMap.get(patternLine.charAt(columnIndex));
                if (layout == null) continue;
                this.layoutItems.put(baseIndex + columnIndex, (Object)layout);
            }
            ++rowIndex;
        }
        return this.layoutItems;
    }
}

