/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.layouts.builder.sized;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.items.ItemLayoutBase;
import team.bytephoria.layout.layouts.base.InventoryHolderBase;
import team.bytephoria.layout.layouts.builder.AbstractLayoutBuilder;
import team.bytephoria.layout.layouts.builder.sized.PatternLayoutBuilder;

public abstract class SizedInventoryBuilder<B extends AbstractLayoutBuilder<B, O>, O extends InventoryHolderBase>
extends AbstractLayoutBuilder<B, O> {
    private static final byte MAX_ROWS = 6;
    private static final byte SLOTS_PER_ROW = 9;
    protected int size = 1;

    protected SizedInventoryBuilder() {
    }

    @NotNull
    public B patterned(@NotNull Consumer<PatternLayoutBuilder> patternBuilderConsumer) {
        PatternLayoutBuilder patternLayoutBuilder = PatternLayoutBuilder.builder();
        patternBuilderConsumer.accept(patternLayoutBuilder);
        this.size = patternLayoutBuilder.size();
        this.itemLayouts.putAll(patternLayoutBuilder.build());
        return this.self();
    }

    public B size(int size) {
        this.size = Math.max(1, Math.min(size, 6)) * 9;
        return this.self();
    }

    public B fill(@NotNull ItemLayoutBase itemLayoutBase, int ... slots) {
        for (int slot : slots) {
            this.item(slot, itemLayoutBase);
        }
        return this.self();
    }

    @Override
    public B fillAll(@NotNull ItemLayoutBase itemLayoutBase) {
        for (int slot = 0; slot < this.size; ++slot) {
            this.item(slot, itemLayoutBase);
        }
        return this.self();
    }

    public B column(int column, @NotNull ItemLayoutBase itemLayoutBase) {
        for (int currentSlot = column; currentSlot < this.size; currentSlot += 9) {
            this.item(currentSlot, itemLayoutBase);
        }
        return this.self();
    }

    public B border(@NotNull ItemLayoutBase itemLayoutBase) {
        int rows = this.size / 9;
        this.row(0, itemLayoutBase);
        this.row(rows - 1, itemLayoutBase);
        for (int row = 1; row < rows - 1; ++row) {
            this.column(row * 9, itemLayoutBase);
            this.column(row * 9 + 8, itemLayoutBase);
        }
        return this.self();
    }

    public B row(int row, @NotNull ItemLayoutBase itemLayoutBase) {
        int slotToStart = row * 9;
        int slotToEnd = Math.min(slotToStart + 8, this.size - 1);
        for (int slot = slotToStart; slot <= slotToEnd; ++slot) {
            this.item(slot, itemLayoutBase);
        }
        return this.self();
    }
}

