/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.layout.layouts.types;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.layout.items.ItemLayoutBase;
import team.bytephoria.layout.layouts.base.LayoutInventoryBase;
import team.bytephoria.layout.layouts.behavior.LayoutBehavior;
import team.bytephoria.layout.layouts.builder.sized.SizedInventoryBuilder;
import team.bytephoria.layout.layouts.editor.LayoutSizedEditor;

public final class LayoutSizedInventory
extends LayoutInventoryBase
implements LayoutSizedEditor {
    private static final byte SLOTS_PER_ROW = 9;

    public LayoutSizedInventory(@NotNull LayoutBehavior layoutBehavior, @NotNull Int2ObjectArrayMap<ItemLayoutBase> itemLayouts, @NotNull Component title, int size) {
        super(layoutBehavior, itemLayouts, title, size);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void column(int column, @NotNull ItemLayoutBase itemLayout) {
        for (int currentSlot = column; currentSlot < this.slots(); currentSlot += 9) {
            this.item(currentSlot, itemLayout);
        }
    }

    @Override
    public void row(int row, @NotNull ItemLayoutBase itemLayout) {
        int slotToStart = row * 9;
        int slotToEnd = slotToStart + 8;
        for (int slot = slotToStart; slot <= slotToEnd; ++slot) {
            this.item(slot, itemLayout);
        }
    }

    @Override
    public void border(@NotNull ItemLayoutBase itemLayout) {
        int rows = this.slots() / 9;
        this.row(0, itemLayout);
        this.row(rows - 1, itemLayout);
        for (int row = 1; row < rows - 1; ++row) {
            this.column(row * 9, itemLayout);
            this.column(row * 9 + 8, itemLayout);
        }
    }

    public static final class Builder
    extends SizedInventoryBuilder<Builder, LayoutSizedInventory> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        @NotNull
        public LayoutSizedInventory build() {
            return new LayoutSizedInventory(this.layoutBehavior, (Int2ObjectArrayMap<ItemLayoutBase>)this.itemLayouts, this.title, this.size);
        }
    }
}

