/*
 * Decompiled with CFR 0.152.
 */
package com.blasty.listeners;

import com.blasty.DoggyPlus;
import com.blasty.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
    }

    @EventHandler
    public void onDogTame(EntityTameEvent event) {
        if (!DoggyPlus.canTameWolves) {
            return;
        }
        if (event.getEntity() instanceof Wolf && event.getOwner() instanceof Player) {
            Player player = (Player)event.getOwner();
            Wolf wolf = (Wolf)event.getEntity();
            Utils.dogMap.put(player.getUniqueId(), wolf);
        }
    }

    @EventHandler
    public void wolfPowers(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location playerLocation = player.getLocation();
        Location wolfLocation = Utils.dogMap.get(player.getUniqueId()).getLocation();
        Wolf wolf = Utils.dogMap.get(player.getUniqueId());
        double dogX = wolfLocation.getX();
        double dogY = wolfLocation.getY();
        double playerX = playerLocation.getX();
        double playerY = playerLocation.getY();
        if (Math.abs(dogX - playerX) <= (double)DoggyPlus.wolfDistance && Math.abs(dogY - playerY) <= (double)DoggyPlus.wolfDistance) {
            if (DoggyPlus.playerSpeedBoost || DoggyPlus.wolfInvulnerability) {
                player.setWalkSpeed(DoggyPlus.walkSpeed);
                wolf.setInvulnerable(true);
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, -1, 4));
            player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, -1, 2));
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.BLUE) + "Doggy powers activated!"));
            wolf.setHealth(player.getHealth() * 2.0);
            wolf.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, -1, 2));
        } else {
            player.setWalkSpeed(0.2f);
            wolf.setInvulnerable(false);
            PotionEffect regenEffect = player.getPotionEffect(PotionEffectType.REGENERATION);
            if (regenEffect != null && regenEffect.getDuration() == -1) {
                player.removePotionEffect(PotionEffectType.REGENERATION);
            }
            PotionEffect playerStrength = player.getPotionEffect(PotionEffectType.STRENGTH);
            PotionEffect wolfStrength = wolf.getPotionEffect(PotionEffectType.STRENGTH);
            if (playerStrength != null && playerStrength.getDuration() == -1 || wolfStrength != null && wolfStrength.getDuration() == -1) {
                player.removePotionEffect(PotionEffectType.STRENGTH);
                wolf.removePotionEffect(PotionEffectType.STRENGTH);
            }
        }
    }
}

