/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.api;

import com.mafuyu404.instantlyinteractinternally.api.FakeLevelAPI;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public final class FakeCaps {
    private FakeCaps() {
    }

    public static <T> void put(ServerPlayer player, BlockPos pos, Key<T> key, LazyOptional<T> value) {
        FakeLevelAPI.putCapability(player, pos, key.capability(), key.side(), value);
    }

    public static <T> LazyOptional<T> get(ServerPlayer player, BlockPos pos, Key<T> key) {
        return FakeLevelAPI.getCapability(player, pos, key.capability(), key.side());
    }

    public static void remove(ServerPlayer player, BlockPos pos, Key<?> key) {
        FakeLevelAPI.removeCapability(player, pos, key.capability(), key.side());
    }

    public static void clearAll(ServerPlayer player, BlockPos pos) {
        FakeLevelAPI.clearCapabilities(player, pos);
    }

    public static final class Key<T> {
        private final Capability<T> cap;
        @Nullable
        private final Direction side;
        @Nullable
        private final ResourceLocation id;

        private Key(Capability<T> cap, @Nullable Direction side, @Nullable ResourceLocation id) {
            this.cap = Objects.requireNonNull(cap, "cap");
            this.side = side;
            this.id = id;
        }

        public static <T> Key<T> of(Capability<T> cap) {
            return new Key<T>(cap, null, null);
        }

        public static <T> Key<T> of(Capability<T> cap, @Nullable Direction side) {
            return new Key<T>(cap, side, null);
        }

        public static <T> Key<T> of(Capability<T> cap, @Nullable Direction side, @Nullable ResourceLocation id) {
            return new Key<T>(cap, side, id);
        }

        public Capability<T> capability() {
            return this.cap;
        }

        @Nullable
        public Direction side() {
            return this.side;
        }

        @Nullable
        public ResourceLocation id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.cap.equals(k.cap) && this.side == k.side && Objects.equals(this.id, k.id);
        }

        public int hashCode() {
            return Objects.hash(this.cap, this.side, this.id);
        }
    }
}

