/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.api;

import com.mafuyu404.instantlyinteractinternally.api.DefaultKeyStrategy;
import com.mafuyu404.instantlyinteractinternally.api.KeyPosProvider;
import com.mafuyu404.instantlyinteractinternally.api.KeyStrategy;
import com.mafuyu404.instantlyinteractinternally.api.VirtualLevelListener;
import com.mafuyu404.instantlyinteractinternally.api.VirtualTransaction;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContext;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContextRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public final class FakeLevelAPI {
    private static final ConcurrentHashMap<UUID, KeyPosProvider> keyPosProviders = new ConcurrentHashMap();
    private static volatile KeyStrategy KEY_STRATEGY = DefaultKeyStrategy.INSTANCE;

    private FakeLevelAPI() {
    }

    public static void setGlobalKeyStrategy(KeyStrategy strategy) {
        if (strategy != null) {
            KEY_STRATEGY = strategy;
        }
    }

    public static KeyStrategy getGlobalKeyStrategy() {
        return KEY_STRATEGY;
    }

    public static String computeKey(ItemStack stack) {
        return KEY_STRATEGY.computeKey(stack);
    }

    public static String computeBaseKey(ItemStack stack) {
        return KEY_STRATEGY.computeBaseKey(stack);
    }

    public static void registerKeyPosProvider(ServerPlayer player, KeyPosProvider provider) {
        if (player == null || provider == null) {
            return;
        }
        keyPosProviders.put(player.m_20148_(), provider);
    }

    public static void unregisterKeyPosProvider(ServerPlayer player, KeyPosProvider provider) {
        if (player == null) {
            return;
        }
        keyPosProviders.remove(player.m_20148_(), provider);
    }

    public static KeyPosProvider getKeyPosProvider(ServerPlayer player) {
        if (player == null) {
            return null;
        }
        return keyPosProviders.get(player.m_20148_());
    }

    public static BlockPos resolveKeyPos(ServerPlayer player, String key) {
        KeyPosProvider p = FakeLevelAPI.getKeyPosProvider(player);
        return p == null ? null : p.resolve(player, key);
    }

    public static void registerSidedItemAccess(ServerPlayer player, BlockPos pos, ISidedItemAccess access) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null) {
            ctx.level.registerSidedAccess(pos, access);
        }
    }

    public static void unregisterSidedItemAccess(ServerPlayer player, BlockPos pos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null) {
            ctx.level.unregisterSidedAccess(pos);
        }
    }

    public static ISidedItemAccess getSidedItemAccess(ServerPlayer player, BlockPos pos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        return ctx != null ? ctx.level.getSidedAccess(pos) : null;
    }

    public static ISidedItemAccess ofContainerMapping(final Supplier<Container> containerSupplier, Map<Direction, int[]> sideToSlots) {
        Objects.requireNonNull(containerSupplier, "containerSupplier");
        final EnumMap<Direction, int[]> map = new EnumMap<Direction, int[]>(Direction.class);
        map.putAll(sideToSlots);
        return new ISidedItemAccess(){

            @Override
            public int getSlots(Direction side) {
                int[] idx = (int[])map.get(side);
                return idx == null ? 0 : idx.length;
            }

            @Override
            public ItemStack getStackInSlot(Direction side, int slot) {
                int[] idx = (int[])map.get(side);
                if (idx == null || slot < 0 || slot >= idx.length) {
                    return ItemStack.f_41583_;
                }
                Container c = (Container)containerSupplier.get();
                return c == null ? ItemStack.f_41583_ : c.m_8020_(idx[slot]);
            }

            @Override
            public void setStackInSlot(Direction side, int slot, ItemStack stack) {
                int[] idx = (int[])map.get(side);
                if (idx == null || slot < 0 || slot >= idx.length) {
                    return;
                }
                Container c = (Container)containerSupplier.get();
                if (c == null) {
                    return;
                }
                c.m_6836_(idx[slot], stack);
            }
        };
    }

    public static void addVirtualLevelListener(ServerPlayer player, VirtualLevelListener listener) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && listener != null) {
            ctx.level.addListener(listener);
        }
    }

    public static void removeVirtualLevelListener(ServerPlayer player, VirtualLevelListener listener) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && listener != null) {
            ctx.level.removeListener(listener);
        }
    }

    public static VirtualTransaction beginTransaction(ServerPlayer player) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null) {
            return VirtualTransaction.NOOP;
        }
        return ctx.level.beginTransaction();
    }

    public static void scheduleTask(ServerPlayer player, Runnable task) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && task != null) {
            ctx.level.schedule(task);
        }
    }

    public static void scheduleTaskEx(ServerPlayer player, Runnable task, ResourceLocation group, int delayTicks, int throttlePerTick, boolean coalesce) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && task != null) {
            ctx.level.schedule(task, group, delayTicks, throttlePerTick, coalesce);
        }
    }

    public static int drainTasks(ServerPlayer player, int maxCount) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null) {
            return 0;
        }
        return ctx.level.drainTasks(maxCount);
    }

    public static <T> void putAttachment(ServerPlayer player, BlockPos pos, ResourceLocation key, T value) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null && key != null) {
            ctx.level.putAttachment(pos, key, value);
        }
    }

    public static <T> T getAttachment(ServerPlayer player, BlockPos pos, ResourceLocation key) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null || key == null) {
            return null;
        }
        return ctx.level.getAttachment(pos, key);
    }

    public static void removeAttachment(ServerPlayer player, BlockPos pos, ResourceLocation key) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null && key != null) {
            ctx.level.removeAttachment(pos, key);
        }
    }

    public static void clearAttachments(ServerPlayer player, BlockPos pos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null) {
            ctx.level.clearAttachments(pos);
        }
    }

    public static <T> void putCapability(ServerPlayer player, BlockPos pos, Capability<T> cap, Direction side, LazyOptional<T> value) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null && cap != null) {
            ctx.level.putCapability(pos, cap, side, value);
        }
    }

    public static <T> LazyOptional<T> getCapability(ServerPlayer player, BlockPos pos, Capability<T> cap, Direction side) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null || cap == null) {
            return LazyOptional.empty();
        }
        return ctx.level.getCapability(pos, cap, side);
    }

    public static void removeCapability(ServerPlayer player, BlockPos pos, Capability<?> cap, Direction side) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null && cap != null) {
            ctx.level.removeCapability(pos, cap, side);
        }
    }

    public static void clearCapabilities(ServerPlayer player, BlockPos pos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null) {
            ctx.level.clearCapabilities(pos);
        }
    }

    public static int transfer(ServerPlayer player, BlockPos pos, Direction from, Direction to, Predicate<ItemStack> filter, int maxMove) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null) {
            return 0;
        }
        return ctx.level.transferItems(pos, from, to, filter, maxMove);
    }

    public static int mergeAll(ServerPlayer player, BlockPos pos, Direction from, Direction to) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null) {
            return 0;
        }
        return ctx.level.mergeAllItems(pos, from, to);
    }

    public static int compress(ServerPlayer player, BlockPos pos, Direction side) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null) {
            return 0;
        }
        return ctx.level.compressItems(pos, side);
    }

    public static void putBlock(ServerPlayer player, BlockPos pos, BlockState state) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null && state != null) {
            ctx.level.putBlock(pos, state);
        }
    }

    public static void removeBlock(ServerPlayer player, BlockPos pos, boolean isMoving) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null) {
            ctx.level.m_7471_(pos, isMoving);
        }
    }

    public static BlockEntity getOrCreateBlockEntity(ServerPlayer player, BlockPos pos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null) {
            return null;
        }
        return ctx.level.getOrCreateBlockEntity(pos);
    }

    public static CompoundTag saveBlockEntityTag(ServerPlayer player, BlockPos pos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx == null || pos == null) {
            return null;
        }
        return ctx.level.saveBlockEntityTag(pos);
    }

    public static void loadBlockEntityTag(ServerPlayer player, BlockPos pos, CompoundTag tag) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && pos != null && tag != null) {
            ctx.level.loadBlockEntityTag(pos, tag);
        }
    }

    public static void copyFromReal(ServerPlayer player, ServerLevel real, BlockPos realPos, BlockPos virtualPos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && real != null && realPos != null && virtualPos != null) {
            ctx.level.copyFromReal(real, realPos, virtualPos);
        }
    }

    public static void flushToReal(ServerPlayer player, ServerLevel real, BlockPos virtualPos, BlockPos realPos) {
        WorldContext ctx = WorldContextRegistry.getContext(player);
        if (ctx != null && real != null && virtualPos != null && realPos != null) {
            ctx.level.flushToReal(real, virtualPos, realPos);
        }
    }

    public static interface ISidedItemAccess {
        public int getSlots(Direction var1);

        public ItemStack getStackInSlot(Direction var1, int var2);

        public void setStackInSlot(Direction var1, int var2, ItemStack var3);
    }
}

