/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.client;

import com.mafuyu404.instantlyinteractinternally.utils.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="instantlyinteractinternally", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientUseProgressOverlay {
    private static boolean active = false;
    private static long startMillis = 0L;
    private static int durationMs = 0;

    private ClientUseProgressOverlay() {
    }

    public static void start(int durationTicks) {
        active = true;
        int dt = Math.max(1, durationTicks);
        durationMs = dt * 50;
        startMillis = Util.m_137550_();
    }

    public static void end() {
        active = false;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post evt) {
        if (!active) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long now = Util.m_137550_();
        int elapsedMs = (int)Math.max(0L, now - startMillis);
        float progress = Mth.m_14036_((float)((float)elapsedMs / (float)durationMs), (float)0.0f, (float)1.0f);
        int sw = evt.getWindow().m_85445_();
        int sh = evt.getWindow().m_85446_();
        float cx = (float)((double)sw * (Double)Config.PROGRESS_X_RATIO.get());
        float cy = (float)((double)sh * (Double)Config.PROGRESS_Y_RATIO.get());
        int outerR = (Integer)Config.PROGRESS_OUTER_RADIUS.get();
        int thickness = (Integer)Config.PROGRESS_THICKNESS.get();
        int innerR = Math.max(1, outerR - thickness);
        int startARGB = ((Long)Config.PROGRESS_START_COLOR.get()).intValue();
        int endARGB = ((Long)Config.PROGRESS_END_COLOR.get()).intValue();
        ClientUseProgressOverlay.drawRingProgress(cx, cy, outerR, innerR, progress, startARGB, endARGB);
        if (((Boolean)Config.PROGRESS_SHOW_COUNTDOWN.get()).booleanValue()) {
            int remainMs = Math.max(0, durationMs - elapsedMs);
            String text = String.format(Locale.ROOT, "%.1f", Float.valueOf((float)remainMs / 1000.0f));
            GuiGraphics gg = evt.getGuiGraphics();
            Font font = mc.f_91062_;
            int tw = font.m_92895_(text);
            Objects.requireNonNull(font);
            int th = 9;
            gg.m_280056_(font, text, (int)(cx - (float)tw / 2.0f), (int)(cy - (float)th / 2.0f + (float)th * 0.25f), -1, true);
        }
        if (progress >= 1.0f) {
            active = false;
        }
    }

    private static void drawRingProgress(float cx, float cy, float outerR, float innerR, float progress, int startARGB, int endARGB) {
        float sweep = 360.0f * progress;
        float startAngle = -90.0f;
        int segments = Math.max(96, (int)(progress * 192.0f));
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= segments; ++i) {
            float t = (float)i / (float)segments;
            float a = startAngle + sweep * t;
            int c = ClientUseProgressOverlay.lerpARGB(startARGB, endARGB, t);
            float cos = Mth.m_14089_((float)(a * ((float)Math.PI / 180)));
            float sin = Mth.m_14031_((float)(a * ((float)Math.PI / 180)));
            float xOuter = cx + cos * outerR;
            float yOuter = cy + sin * outerR;
            float xInner = cx + cos * innerR;
            float yInner = cy + sin * innerR;
            ClientUseProgressOverlay.putVertex(buf, xOuter, yOuter, c);
            ClientUseProgressOverlay.putVertex(buf, xInner, yInner, c);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
    }

    private static int lerpARGB(int a, int b, float t) {
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        int aa = (int)((float)(a >> 24 & 0xFF) * (1.0f - t) + (float)(b >> 24 & 0xFF) * t);
        int rr = (int)((float)(a >> 16 & 0xFF) * (1.0f - t) + (float)(b >> 16 & 0xFF) * t);
        int gg = (int)((float)(a >> 8 & 0xFF) * (1.0f - t) + (float)(b >> 8 & 0xFF) * t);
        int bb = (int)((float)(a & 0xFF) * (1.0f - t) + (float)(b & 0xFF) * t);
        return aa << 24 | rr << 16 | gg << 8 | bb;
    }

    private static void putVertex(BufferBuilder b, float x, float y, int argb) {
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float bl = (float)(argb & 0xFF) / 255.0f;
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        b.m_5483_((double)x, (double)y, 0.0).m_85950_(r, g, bl, a).m_5752_();
    }
}

