/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.network;

import com.mafuyu404.instantlyinteractinternally.utils.Utils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerInventoryUse {
    private final int containerSlotIndex;
    private final ActionType actionType;

    public ServerInventoryUse(int containerSlotIndex, ActionType actionType) {
        this.containerSlotIndex = containerSlotIndex;
        this.actionType = actionType;
    }

    public static void encode(ServerInventoryUse msg, FriendlyByteBuf buffer) {
        buffer.m_130130_(msg.containerSlotIndex);
        buffer.m_130068_((Enum)msg.actionType);
    }

    public static ServerInventoryUse decode(FriendlyByteBuf buffer) {
        int idx = buffer.m_130242_();
        ActionType type = (ActionType)buffer.m_130066_(ActionType.class);
        return new ServerInventoryUse(idx, type);
    }

    public static void handle(ServerInventoryUse msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Slot slot;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || player.f_36096_ == null) {
                return;
            }
            try {
                slot = player.f_36096_.m_38853_(msg.containerSlotIndex);
            }
            catch (IndexOutOfBoundsException e) {
                return;
            }
            if (slot == null || !slot.m_6657_()) {
                return;
            }
            switch (msg.actionType) {
                case BLOCK_INTERACT: {
                    if (slot.m_7993_().m_41614_()) {
                        boolean used = Utils.useUsableItemInstant(slot, player);
                        if (!used) {
                            Utils.consumeItemInstant(slot, player);
                        }
                        return;
                    }
                    Utils.interactBlockInSandbox(slot.m_7993_(), player);
                    break;
                }
                case ITEM_USE: {
                    ItemStack stack = slot.m_7993_();
                    Item item = stack.m_41720_();
                    if (item instanceof BlockItem && !stack.m_41614_()) {
                        Utils.interactBlockInSandbox(stack, player);
                        return;
                    }
                    boolean used = Utils.useUsableItemInstant(slot, player);
                    if (used) break;
                    Utils.consumeItemInstant(slot, player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum ActionType {
        BLOCK_INTERACT,
        ITEM_USE;

    }
}

