/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils;

import com.mafuyu404.instantlyinteractinternally.Instantlyinteractinternally;
import com.mafuyu404.instantlyinteractinternally.api.FakeLevelAPI;
import com.mafuyu404.instantlyinteractinternally.api.VirtualLevelListener;
import com.mafuyu404.instantlyinteractinternally.api.VirtualTransaction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class FakeLevel
extends Level {
    private final ServerLevel delegate;
    private final Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    private final Map<BlockPos, BlockEntity> blockEntities = new HashMap<BlockPos, BlockEntity>();
    private final Map<BlockPos, FakeLevelAPI.ISidedItemAccess> sidedAccess = new HashMap<BlockPos, FakeLevelAPI.ISidedItemAccess>();
    private final List<VirtualLevelListener> listeners = new CopyOnWriteArrayList<VirtualLevelListener>();
    private final Map<BlockPos, Map<ResourceLocation, Object>> attachments = new HashMap<BlockPos, Map<ResourceLocation, Object>>();
    private final ArrayDeque<Runnable> taskQueue = new ArrayDeque();
    private final Map<BlockPos, Map<Capability<?>, EnumMap<Direction, LazyOptional<?>>>> capabilities = new HashMap();
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    private final Map<ResourceLocation, Integer> groupTickCount = new HashMap<ResourceLocation, Integer>();
    private long lastDrainTick = Long.MIN_VALUE;

    public FakeLevel(ServerLevel delegate) {
        super((WritableLevelData)delegate.m_6106_(), delegate.m_46472_(), delegate.m_9598_(), delegate.m_204156_(), delegate.m_46658_(), false, delegate.m_46659_(), delegate.m_7328_(), delegate.m_7654_().m_213994_());
        this.delegate = delegate;
    }

    public void addListener(VirtualLevelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeListener(VirtualLevelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void schedule(Runnable r) {
        if (r != null) {
            this.taskQueue.addLast(r);
        }
    }

    public void schedule(Runnable r, @Nullable ResourceLocation group, int delayTicks, int throttlePerTick, boolean coalesce) {
        if (r == null) {
            return;
        }
        long now = this.delegate.m_46467_();
        long runAt = now + (long)Math.max(0, delayTicks);
        if (coalesce && group != null) {
            for (ScheduledTask t : this.scheduledTasks) {
                if (!group.equals((Object)t.group) || t.executed) continue;
                return;
            }
        }
        this.scheduledTasks.add(new ScheduledTask(r, group, runAt, throttlePerTick, coalesce));
    }

    public int drainTasks(int maxCount) {
        int n = 0;
        long now = this.delegate.m_46467_();
        if (this.lastDrainTick != now) {
            this.groupTickCount.clear();
            this.lastDrainTick = now;
        }
        Iterator<ScheduledTask> it = this.scheduledTasks.iterator();
        while (it.hasNext() && (maxCount <= 0 || n < maxCount)) {
            ScheduledTask t = it.next();
            if (t.executed) {
                it.remove();
                continue;
            }
            if (t.runAt > now) continue;
            if (t.group != null && t.throttlePerTick > 0) {
                int used = this.groupTickCount.getOrDefault(t.group, 0);
                if (used >= t.throttlePerTick) continue;
                this.groupTickCount.put(t.group, used + 1);
            }
            try {
                t.r.run();
            }
            catch (Throwable err) {
                Instantlyinteractinternally.LOGGER.warn("[FakeLevel] scheduled task error", err);
            }
            t.executed = true;
            it.remove();
            ++n;
        }
        while (!(this.taskQueue.isEmpty() || maxCount > 0 && n >= maxCount)) {
            Runnable r = this.taskQueue.pollFirst();
            if (r == null) continue;
            try {
                r.run();
            }
            catch (Throwable t) {
                Instantlyinteractinternally.LOGGER.warn("[FakeLevel] immediate task error", t);
            }
            ++n;
        }
        return n;
    }

    public <T> void putAttachment(BlockPos pos, ResourceLocation key, T value) {
        Map map = this.attachments.computeIfAbsent(pos.m_7949_(), p -> new HashMap());
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public <T> T getAttachment(BlockPos pos, ResourceLocation key) {
        Map<ResourceLocation, Object> map = this.attachments.get(pos);
        return (T)(map == null ? null : map.get(key));
    }

    public void removeAttachment(BlockPos pos, ResourceLocation key) {
        Map<ResourceLocation, Object> map = this.attachments.get(pos);
        if (map != null) {
            map.remove(key);
            if (map.isEmpty()) {
                this.attachments.remove(pos);
            }
        }
    }

    public void clearAttachments(BlockPos pos) {
        this.attachments.remove(pos);
    }

    public <T> void putCapability(BlockPos pos, Capability<T> cap, @Nullable Direction side, LazyOptional<T> value) {
        if (pos == null || cap == null) {
            return;
        }
        EnumMap bySide = this.capabilities.computeIfAbsent(pos.m_7949_(), p -> new HashMap()).computeIfAbsent(cap, c -> new EnumMap(Direction.class));
        bySide.put(side == null ? Direction.UP : side, value == null ? LazyOptional.empty() : value);
    }

    public <T> LazyOptional<T> getCapability(BlockPos pos, Capability<T> cap, @Nullable Direction side) {
        if (pos == null || cap == null) {
            return LazyOptional.empty();
        }
        Map<Capability<?>, EnumMap<Direction, LazyOptional<?>>> byCap = this.capabilities.get(pos);
        if (byCap == null) {
            return LazyOptional.empty();
        }
        EnumMap<Direction, LazyOptional<?>> bySide = byCap.get(cap);
        if (bySide == null) {
            return LazyOptional.empty();
        }
        LazyOptional<?> lo = bySide.get(side == null ? Direction.UP : side);
        return lo == null ? LazyOptional.empty() : lo;
    }

    public void removeCapability(BlockPos pos, Capability<?> cap, @Nullable Direction side) {
        Map<Capability<?>, EnumMap<Direction, LazyOptional<?>>> byCap = this.capabilities.get(pos);
        if (byCap == null) {
            return;
        }
        EnumMap<Direction, LazyOptional<?>> bySide = byCap.get(cap);
        if (bySide == null) {
            return;
        }
        if (side == null) {
            bySide.clear();
        } else {
            bySide.remove(side);
        }
        if (bySide.isEmpty()) {
            byCap.remove(cap);
        }
        if (byCap.isEmpty()) {
            this.capabilities.remove(pos);
        }
    }

    public void clearCapabilities(BlockPos pos) {
        this.capabilities.remove(pos);
    }

    public void putBlock(BlockPos pos, BlockState newState) {
        BlockState oldState = this.blocks.get(pos);
        if (oldState != null && oldState != newState) {
            oldState.m_60753_((Level)this, pos, newState, false);
        }
        this.blocks.put(pos, newState);
        Block block = newState.m_60734_();
        if (block instanceof BaseEntityBlock) {
            BaseEntityBlock beb = (BaseEntityBlock)block;
            BlockEntity be = this.blockEntities.get(pos);
            if (be == null || be.m_58903_() == null || !be.m_58903_().m_155262_(newState)) {
                be = beb.m_142194_(pos, newState);
            }
            if (be != null) {
                be.m_142339_((Level)this);
                this.blockEntities.put(pos, be);
                for (VirtualLevelListener l : this.listeners) {
                    try {
                        l.onBlockEntityLoaded(this, pos, be);
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.blockEntities.remove(pos);
            }
        } else {
            this.blockEntities.remove(pos);
        }
        if (oldState == null || oldState.m_60734_() != newState.m_60734_()) {
            newState.m_60696_((Level)this, pos, oldState == null ? Blocks.f_50016_.m_49966_() : oldState, false);
        }
        for (VirtualLevelListener l : this.listeners) {
            try {
                l.onPutBlock(this, pos, newState, oldState);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean m_7471_(BlockPos pos, boolean isMoving) {
        BlockState oldState = this.blocks.remove(pos);
        BlockState newState = Blocks.f_50016_.m_49966_();
        this.blockEntities.remove(pos);
        this.attachments.remove(pos);
        this.capabilities.remove(pos);
        if (oldState != null) {
            oldState.m_60753_((Level)this, pos, newState, isMoving);
            for (VirtualLevelListener l : this.listeners) {
                try {
                    l.onRemoveBlock(this, pos, oldState);
                }
                catch (Throwable throwable) {}
            }
        }
        return true;
    }

    public void moveBlockWithBE(BlockPos from, BlockPos to) {
        if (from.equals((Object)to)) {
            return;
        }
        BlockState state = this.blocks.get(from);
        BlockEntity oldBe = this.blockEntities.get(from);
        BlockState toOld = this.blocks.get(to);
        if (toOld != null) {
            this.m_7471_(to, false);
        }
        if (state == null) {
            this.m_7471_(from, false);
            return;
        }
        this.blocks.put(to, state);
        BlockEntity newBe = null;
        if (oldBe != null) {
            Block block;
            tag = oldBe.m_187480_();
            newBe = BlockEntity.m_155241_((BlockPos)to, (BlockState)state, (CompoundTag)tag);
            if (newBe == null && (block = state.m_60734_()) instanceof BaseEntityBlock) {
                BaseEntityBlock beb = (BaseEntityBlock)block;
                newBe = beb.m_142194_(to, state);
            }
        } else {
            tag = state.m_60734_();
            if (tag instanceof BaseEntityBlock) {
                BaseEntityBlock beb = (BaseEntityBlock)tag;
                newBe = beb.m_142194_(to, state);
            }
        }
        if (newBe != null) {
            newBe.m_142339_((Level)this);
            this.blockEntities.put(to, newBe);
        } else {
            this.blockEntities.remove(to);
        }
        BlockState air = Blocks.f_50016_.m_49966_();
        state.m_60696_((Level)this, to, air, false);
        BlockState fromOld = this.blocks.remove(from);
        this.blockEntities.remove(from);
        if (fromOld != null) {
            fromOld.m_60753_((Level)this, from, air, false);
        }
        for (VirtualLevelListener l : this.listeners) {
            try {
                l.onMoveBlock(this, from, to, state);
            }
            catch (Throwable throwable) {}
        }
    }

    @Nullable
    public BlockEntity getOrCreateBlockEntity(BlockPos pos) {
        BaseEntityBlock beb;
        Object object;
        BlockState state = this.blocks.get(pos);
        if (state == null) {
            return null;
        }
        BlockEntity be = this.blockEntities.get(pos);
        if (be == null && (object = state.m_60734_()) instanceof BaseEntityBlock && (be = (beb = (BaseEntityBlock)object).m_142194_(pos, state)) != null) {
            be.m_142339_((Level)this);
            this.blockEntities.put(pos, be);
            for (VirtualLevelListener l : this.listeners) {
                try {
                    l.onBlockEntityLoaded(this, pos, be);
                }
                catch (Throwable throwable) {}
            }
        }
        return be;
    }

    public void loadBlockEntityTag(BlockPos pos, CompoundTag tag) {
        BlockState state = this.blocks.get(pos);
        if (state == null) {
            return;
        }
        BlockEntity be = BlockEntity.m_155241_((BlockPos)pos, (BlockState)state, (CompoundTag)tag);
        if (be != null) {
            be.m_142339_((Level)this);
            this.blockEntities.put(pos, be);
            for (VirtualLevelListener l : this.listeners) {
                try {
                    l.onBlockEntityLoaded(this, pos, be);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public CompoundTag saveBlockEntityTag(BlockPos pos) {
        BlockEntity be = this.blockEntities.get(pos);
        return be == null ? null : be.m_187480_();
    }

    public void copyFromReal(ServerLevel real, BlockPos realPos, BlockPos virtualPos) {
        BlockState rs = real.m_8055_(realPos);
        this.putBlock(virtualPos, rs);
        BlockEntity rbe = real.m_7702_(realPos);
        if (rbe != null) {
            CompoundTag tag = rbe.m_187480_();
            this.loadBlockEntityTag(virtualPos, tag);
        }
        for (VirtualLevelListener l : this.listeners) {
            try {
                l.onCopyFromReal(real, realPos, this, virtualPos);
            }
            catch (Throwable throwable) {}
        }
    }

    public void flushToReal(ServerLevel real, BlockPos virtualPos, BlockPos realPos) {
        BlockState vs = this.blocks.get(virtualPos);
        if (vs == null) {
            real.m_7731_(realPos, Blocks.f_50016_.m_49966_(), 3);
            real.m_46747_(realPos);
        } else {
            real.m_7731_(realPos, vs, 3);
            BlockEntity vbe = this.blockEntities.get(virtualPos);
            if (vbe != null) {
                BaseEntityBlock beb;
                Block block;
                CompoundTag tag = vbe.m_187480_();
                BlockEntity rbe = real.m_7702_(realPos);
                if (rbe == null && (block = vs.m_60734_()) instanceof BaseEntityBlock && (rbe = (beb = (BaseEntityBlock)block).m_142194_(realPos, vs)) != null) {
                    real.m_151523_(rbe);
                }
                if (rbe != null) {
                    rbe.m_142466_(tag);
                    rbe.m_6596_();
                }
                real.m_7260_(realPos, vs, vs, 3);
            }
        }
        for (VirtualLevelListener l : this.listeners) {
            try {
                l.onFlushToReal(this, virtualPos, real, realPos);
            }
            catch (Throwable throwable) {}
        }
    }

    public VirtualTransaction beginTransaction() {
        final Snapshot snap = Snapshot.capture(this);
        return new VirtualTransaction(){
            private boolean active = true;

            @Override
            public void commit() {
                this.active = false;
            }

            @Override
            public void rollback() {
                if (!this.active) {
                    return;
                }
                snap.restore(FakeLevel.this);
                this.active = false;
            }

            @Override
            public boolean isActive() {
                return this.active;
            }

            @Override
            public void close() {
                if (this.isActive()) {
                    this.rollback();
                }
            }
        };
    }

    public void registerSidedAccess(BlockPos pos, FakeLevelAPI.ISidedItemAccess access) {
        if (pos == null || access == null) {
            return;
        }
        this.sidedAccess.put(pos.m_7949_(), access);
    }

    public void unregisterSidedAccess(BlockPos pos) {
        if (pos == null) {
            return;
        }
        this.sidedAccess.remove(pos);
    }

    public FakeLevelAPI.ISidedItemAccess getSidedAccess(BlockPos pos) {
        return pos == null ? null : this.sidedAccess.get(pos);
    }

    public int transferItems(BlockPos pos, Direction from, Direction to, @Nullable Predicate<ItemStack> filter, int maxMove) {
        FakeLevelAPI.ISidedItemAccess acc = this.getSidedAccess(pos);
        if (acc == null || maxMove == 0) {
            return 0;
        }
        int moved = 0;
        int srcSlots = acc.getSlots(from);
        int dstSlots = acc.getSlots(to);
        block0: for (int si = 0; si < srcSlots && (maxMove < 0 || moved < maxMove); ++si) {
            int can;
            ItemStack d;
            int di;
            ItemStack s = acc.getStackInSlot(from, si);
            if (s.m_41619_() || filter != null && !filter.test(s)) continue;
            for (di = 0; di < dstSlots && (maxMove < 0 || moved < maxMove); ++di) {
                d = acc.getStackInSlot(to, di);
                if (d.m_41619_() || !ItemStack.m_150942_((ItemStack)s, (ItemStack)d) || d.m_41613_() >= d.m_41741_()) continue;
                can = Math.min(s.m_41613_(), d.m_41741_() - d.m_41613_());
                if (maxMove > 0) {
                    can = Math.min(can, maxMove - moved);
                }
                if (can <= 0) continue;
                s = this.applyItemTransfer(acc, from, si, s, to, di, d, can);
                moved += can;
                if (s.m_41619_()) break;
            }
            if (s.m_41619_() || maxMove >= 0 && moved >= maxMove) continue;
            for (di = 0; di < dstSlots && (maxMove < 0 || moved < maxMove); ++di) {
                d = acc.getStackInSlot(to, di);
                if (!d.m_41619_()) continue;
                int n = can = maxMove < 0 ? s.m_41613_() : Math.min(s.m_41613_(), maxMove - moved);
                if (can <= 0) continue;
                ItemStack part = s.m_41777_();
                part.m_41764_(can);
                s = this.applyItemTransfer(acc, from, si, s, to, di, ItemStack.f_41583_, can, part);
                moved += can;
                if (s.m_41619_()) continue block0;
            }
        }
        return moved;
    }

    public int mergeAllItems(BlockPos pos, Direction from, Direction to) {
        return this.transferItems(pos, from, to, stack -> true, -1);
    }

    public int compressItems(BlockPos pos, Direction side) {
        FakeLevelAPI.ISidedItemAccess acc = this.getSidedAccess(pos);
        if (acc == null) {
            return 0;
        }
        int slots = acc.getSlots(side);
        int compressed = 0;
        block0: for (int i = 0; i < slots; ++i) {
            ItemStack a = acc.getStackInSlot(side, i);
            if (a.m_41619_() || a.m_41613_() >= a.m_41741_()) continue;
            for (int j = i + 1; j < slots; ++j) {
                int can;
                ItemStack b = acc.getStackInSlot(side, j);
                if (b.m_41619_() || !ItemStack.m_150942_((ItemStack)a, (ItemStack)b) || (can = Math.min(b.m_41613_(), a.m_41741_() - a.m_41613_())) <= 0) continue;
                a = this.applyItemTransfer(acc, side, i, a, side, j, b, can);
                compressed += can;
                if (a.m_41613_() >= a.m_41741_()) continue block0;
            }
        }
        return compressed;
    }

    private ItemStack applyItemTransfer(FakeLevelAPI.ISidedItemAccess acc, Direction from, int fromSlot, ItemStack src, Direction to, int toSlot, ItemStack dst, int amount) {
        return this.applyItemTransfer(acc, from, fromSlot, src, to, toSlot, dst, amount, null);
    }

    private ItemStack applyItemTransfer(FakeLevelAPI.ISidedItemAccess acc, Direction from, int fromSlot, ItemStack src, Direction to, int toSlot, ItemStack dst, int amount, @Nullable ItemStack inserted) {
        ItemStack newDst = inserted != null ? inserted : dst.m_41777_();
        newDst.m_41769_(amount);
        ItemStack newSrc = src.m_41777_();
        newSrc.m_41774_(amount);
        acc.setStackInSlot(to, toSlot, newDst);
        acc.setStackInSlot(from, fromSlot, newSrc);
        return newSrc;
    }

    @Nullable
    public MinecraftServer m_7654_() {
        return this.delegate.m_7654_();
    }

    public Holder<Biome> m_203675_(int p_204159_, int p_204160_, int p_204161_) {
        return this.delegate.m_203675_(p_204159_, p_204160_, p_204161_);
    }

    public boolean m_5776_() {
        return false;
    }

    public float m_7717_(Direction p_45522_, boolean p_45523_) {
        return 0.0f;
    }

    public LevelLightEngine m_5518_() {
        return this.delegate.m_5518_();
    }

    public LevelChunk m_6325_(int x, int z) {
        return this.delegate.m_6325_(x, z);
    }

    public FeatureFlagSet m_246046_() {
        return this.delegate.m_246046_();
    }

    public LevelChunk m_46745_(BlockPos pos) {
        return this.delegate.m_46745_(pos);
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    @Nullable
    public Entity m_6815_(int p_46492_) {
        return this.delegate.m_6815_(p_46492_);
    }

    @Nullable
    public MapItemSavedData m_7489_(String p_46650_) {
        return this.delegate.m_7489_(p_46650_);
    }

    public void m_142325_(String p_151533_, MapItemSavedData p_151534_) {
        this.delegate.m_142325_(p_151533_, p_151534_);
    }

    public int m_7354_() {
        return this.delegate.m_7354_();
    }

    public void m_6801_(int p_46506_, BlockPos p_46507_, int p_46508_) {
        this.delegate.m_6801_(p_46506_, p_46507_, p_46508_);
    }

    public Scoreboard m_6188_() {
        return this.delegate.m_6188_();
    }

    public RecipeManager m_7465_() {
        return this.delegate.m_7465_();
    }

    public DimensionDataStorage getDataStorage() {
        return this.delegate.m_8895_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return this.delegate.getCapability(cap, side);
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.delegate.m_142646_();
    }

    public BlockState m_8055_(BlockPos pos) {
        BlockState state = this.blocks.get(pos);
        return state != null ? state : Blocks.f_50016_.m_49966_();
    }

    public FluidState m_6425_(BlockPos pos) {
        return Fluids.f_76191_.m_76145_();
    }

    public void m_262808_(@Nullable Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
        this.delegate.m_262808_(p_262953_, p_263004_, p_263398_, p_263376_, p_263359_, p_263020_, p_263055_, p_262914_, p_262991_);
    }

    public void m_213890_(@Nullable Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
        this.delegate.m_213890_(p_220372_, p_220373_, p_263500_, p_220375_, p_220376_, p_220377_, p_220378_);
    }

    public String m_46464_() {
        return this.delegate.m_46464_();
    }

    public boolean m_6933_(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        this.putBlock(pos, state);
        return true;
    }

    public void m_7260_(BlockPos p_46612_, BlockState p_46613_, BlockState p_46614_, int p_46615_) {
        this.delegate.m_7260_(p_46612_, p_46613_, p_46614_, p_46615_);
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return this.blockEntities.get(pos);
    }

    public void m_151523_(BlockEntity blockEntity) {
        this.blockEntities.put(blockEntity.m_58899_(), blockEntity);
    }

    public void m_46747_(BlockPos pos) {
        this.blockEntities.remove(pos);
    }

    public boolean m_7967_(Entity entity) {
        return false;
    }

    public LevelTickAccess<Block> m_183326_() {
        return this.delegate.m_183326_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return this.delegate.m_183324_();
    }

    public ChunkSource m_7726_() {
        return this.delegate.m_7726_();
    }

    public void m_5898_(@Nullable Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
        this.delegate.m_5898_(p_46771_, p_46772_, p_46773_, p_46774_);
    }

    public void m_214171_(GameEvent p_220404_, Vec3 p_220405_, GameEvent.Context p_220406_) {
        this.delegate.m_214171_(p_220404_, p_220405_, p_220406_);
    }

    public List<? extends Player> m_6907_() {
        return this.delegate.m_6907_();
    }

    private static final class ScheduledTask {
        final Runnable r;
        @Nullable
        final ResourceLocation group;
        final long runAt;
        final int throttlePerTick;
        final boolean coalesce;
        boolean executed;

        ScheduledTask(Runnable r, @Nullable ResourceLocation group, long runAt, int throttlePerTick, boolean coalesce) {
            this.r = r;
            this.group = group;
            this.runAt = runAt;
            this.throttlePerTick = Math.max(0, throttlePerTick);
            this.coalesce = coalesce;
            this.executed = false;
        }

        ScheduledTask copy() {
            ScheduledTask c = new ScheduledTask(this.r, this.group, this.runAt, this.throttlePerTick, this.coalesce);
            c.executed = this.executed;
            return c;
        }
    }

    private record Snapshot(Map<BlockPos, BlockState> blocks, Map<BlockPos, CompoundTag> bes, Map<BlockPos, Map<ResourceLocation, Object>> attachments, Map<BlockPos, FakeLevelAPI.ISidedItemAccess> sided, Map<BlockPos, Map<Capability<?>, EnumMap<Direction, LazyOptional<?>>>> caps, List<ScheduledTask> scheduledCopy) {
        private static <K, V, W> Map<K, Map<V, W>> deepCopyMapOfMaps(Map<K, Map<V, W>> original) {
            HashMap<K, HashMap<V, W>> copy = new HashMap<K, HashMap<V, W>>();
            for (Map.Entry<K, Map<V, W>> entry : original.entrySet()) {
                copy.put(entry.getKey(), new HashMap<V, W>(entry.getValue()));
            }
            return copy;
        }

        private static <K, C, T> Map<K, Map<C, EnumMap<Direction, T>>> deepCopyMapOfEnumMaps(Map<K, Map<C, EnumMap<Direction, T>>> original) {
            HashMap copy = new HashMap();
            for (Map.Entry<K, Map<C, EnumMap<Direction, T>>> entry : original.entrySet()) {
                HashMap<C, EnumMap<Direction, T>> innerCopy = new HashMap<C, EnumMap<Direction, T>>();
                for (Map.Entry<C, EnumMap<Direction, T>> innerEntry : entry.getValue().entrySet()) {
                    innerCopy.put(innerEntry.getKey(), new EnumMap<Direction, T>(innerEntry.getValue()));
                }
                copy.put(entry.getKey(), innerCopy);
            }
            return copy;
        }

        private static List<ScheduledTask> copyScheduledTasks(List<ScheduledTask> tasks) {
            ArrayList<ScheduledTask> copy = new ArrayList<ScheduledTask>(tasks.size());
            for (ScheduledTask task : tasks) {
                copy.add(task.copy());
            }
            return copy;
        }

        static Snapshot capture(FakeLevel level) {
            return new Snapshot(new HashMap<BlockPos, BlockState>(level.blocks), Snapshot.copyBlockEntities(level.blockEntities), Snapshot.deepCopyMapOfMaps(level.attachments), new HashMap<BlockPos, FakeLevelAPI.ISidedItemAccess>(level.sidedAccess), Snapshot.deepCopyMapOfEnumMaps(level.capabilities), Snapshot.copyScheduledTasks(level.scheduledTasks));
        }

        private static Map<BlockPos, CompoundTag> copyBlockEntities(Map<BlockPos, BlockEntity> blockEntities) {
            HashMap<BlockPos, CompoundTag> copy = new HashMap<BlockPos, CompoundTag>();
            for (Map.Entry<BlockPos, BlockEntity> entry : blockEntities.entrySet()) {
                copy.put(entry.getKey(), entry.getValue().m_187480_());
            }
            return copy;
        }

        void restore(FakeLevel level) {
            level.blocks.clear();
            level.blocks.putAll(this.blocks);
            this.restoreBlockEntities(level);
            level.attachments.clear();
            level.attachments.putAll(Snapshot.deepCopyMapOfMaps(this.attachments));
            level.sidedAccess.clear();
            level.sidedAccess.putAll(this.sided);
            level.capabilities.clear();
            level.capabilities.putAll(Snapshot.deepCopyMapOfEnumMaps(this.caps));
            level.scheduledTasks.clear();
            level.scheduledTasks.addAll(Snapshot.copyScheduledTasks(this.scheduledCopy));
        }

        private void restoreBlockEntities(FakeLevel level) {
            level.blockEntities.clear();
            for (Map.Entry<BlockPos, CompoundTag> entry : this.bes.entrySet()) {
                Block block;
                BlockPos pos = entry.getKey();
                BlockState state = level.blocks.get(pos);
                if (state == null) continue;
                BlockEntity be = BlockEntity.m_155241_((BlockPos)pos, (BlockState)state, (CompoundTag)entry.getValue());
                if (be == null && (block = state.m_60734_()) instanceof BaseEntityBlock) {
                    BaseEntityBlock beb = (BaseEntityBlock)block;
                    be = beb.m_142194_(pos, state);
                }
                if (be == null) continue;
                be.m_142339_((Level)level);
                level.blockEntities.put(pos, be);
            }
        }
    }
}

