/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils;

import com.mafuyu404.instantlyinteractinternally.Instantlyinteractinternally;
import com.mafuyu404.instantlyinteractinternally.api.FakeLevelAPI;
import com.mafuyu404.instantlyinteractinternally.utils.Utils;
import com.mafuyu404.instantlyinteractinternally.utils.VirtualContainerGuard;
import com.mafuyu404.instantlyinteractinternally.utils.service.SessionService;
import com.mafuyu404.instantlyinteractinternally.utils.service.TransferService;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContextRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="instantlyinteractinternally", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VirtualWorldEvents {
    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            while (SessionService.getActiveSessionId(sp) != null) {
                SessionService.flushActiveSession(sp, true);
            }
            VirtualContainerGuard.end(sp);
            WorldContextRegistry.clear(sp);
        }
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        VirtualContainerGuard.setCurrentContainer(sp, event.getContainer());
        String active = SessionService.getActiveSessionId(sp);
        if (active != null) {
            VirtualContainerGuard.clearSuppressedCloseSession(sp, active);
        }
        Instantlyinteractinternally.debug("[VWE] \u6253\u5f00\u5bb9\u5668 menu={} \u73a9\u5bb6={} activeSid={}", event.getContainer().getClass().getSimpleName(), sp.m_36316_().getName(), active);
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close event) {
        ItemStack sItem;
        int i;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Instantlyinteractinternally.debug("[VWE] \u6b63\u5728\u5173\u95ed\u5bb9\u5668 menu={} \u73a9\u5bb6={}", event.getContainer().getClass().getSimpleName(), sp.m_36316_().getName());
        VirtualContainerGuard.Session s = VirtualContainerGuard.getSession(sp);
        if (s != null && s.containerMenu == event.getContainer() && !s.isContainerSession) {
            Instantlyinteractinternally.debug("[VWE] \u6355\u83b7\u5230\u5173\u95ed\u5f53\u524d\u4f1a\u8bddGUI sid={}\uff0c\u5ef6\u8fdf\u5224\u5b9a\u662f\u5426\u6700\u7ec8\u5237\u76d8", s.sessionId);
            SessionService.flushActiveSession(sp, true);
        }
        SessionService.flushSessionsInContainer(sp, event.getContainer());
        SessionService.finalizeSessionsForParentClose(sp, event.getContainer());
        VirtualContainerGuard.Session top = VirtualContainerGuard.getSession(sp);
        if (top != null && top.isContainerSession && top.containerMenu == event.getContainer()) {
            Instantlyinteractinternally.debug("[VWE] \u5f39\u51fa\u7236\u5bb9\u5668\u4f1a\u8bdd\u5360\u4f4d\u7b26 menu={}", event.getContainer().getClass().getSimpleName());
            VirtualContainerGuard.endCurrentSession(sp);
        }
        Inventory inv = sp.m_150109_();
        for (i = 0; i < inv.f_35974_.size(); ++i) {
            sItem = (ItemStack)inv.f_35974_.get(i);
            if (sItem.m_41619_()) continue;
            Utils.clearPendingBind(sItem);
        }
        for (i = 0; i < inv.f_35976_.size(); ++i) {
            sItem = (ItemStack)inv.f_35976_.get(i);
            if (sItem.m_41619_()) continue;
            Utils.clearPendingBind(sItem);
        }
        inv.m_6596_();
        sp.f_36096_.m_38946_();
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        BlockItem biOff;
        Item item;
        boolean offResolvable;
        BlockItem biMain;
        Item item2;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)entity;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel realLevel = (ServerLevel)levelAccessor;
        SessionService.flushActiveSession(sp);
        BlockPos pos = event.getPos();
        BlockState placedState = event.getState();
        ItemStack candidate = ItemStack.f_41583_;
        ItemStack main = sp.m_21205_();
        ItemStack off = sp.m_21206_();
        boolean mainResolvable = !main.m_41619_() && (item2 = main.m_41720_()) instanceof BlockItem && (biMain = (BlockItem)item2).m_40614_() == placedState.m_60734_() && FakeLevelAPI.resolveKeyPos(sp, FakeLevelAPI.computeKey(main)) != null;
        boolean bl = offResolvable = !off.m_41619_() && (item = off.m_41720_()) instanceof BlockItem && (biOff = (BlockItem)item).m_40614_() == placedState.m_60734_() && FakeLevelAPI.resolveKeyPos(sp, FakeLevelAPI.computeKey(off)) != null;
        if (mainResolvable) {
            candidate = main;
        } else if (offResolvable) {
            candidate = off;
        } else if (main.m_41720_() instanceof BlockItem) {
            candidate = main;
        } else if (off.m_41720_() instanceof BlockItem) {
            candidate = off;
        }
        if (!candidate.m_41619_()) {
            TransferService.transferFromFakeToReal(sp, candidate, realLevel, pos);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MinecraftServer server = event.getServer();
        WorldContextRegistry.saveAllAndClear(server);
    }
}

