/*
 * Decompiled with CFR 0.152.
 */
package org.opnsoc.opac_better_commands.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.opnsoc.opac_better_commands.listener.PartyChatListener;
import org.opnsoc.opac_better_commands.utils.PartyMessenger;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;

public class PartyChatCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> true);
        Command toggleAction = ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            UUID id = player.getUUID();
            boolean newState = PartyChatListener.PARTY_CHAT_ENABLED.getOrDefault(id, false) == false;
            PartyChatListener.PARTY_CHAT_ENABLED.put(id, newState);
            MutableComponent stateText = Component.literal((String)(newState ? "enabled" : "disabled")).withStyle(newState ? ChatFormatting.GREEN : ChatFormatting.RED);
            player.sendSystemMessage((Component)Component.literal((String)"Party chat is now").append((Component)Component.literal((String)" ")).append((Component)stateText));
            return 1;
        };
        Command statusAction = ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            boolean state = PartyChatListener.PARTY_CHAT_ENABLED.getOrDefault(player.getUUID(), false);
            MutableComponent stateText = Component.literal((String)(state ? "enabled" : "disabled")).withStyle(state ? ChatFormatting.GREEN : ChatFormatting.RED);
            player.sendSystemMessage((Component)Component.literal((String)"Party chat has been").append((Component)Component.literal((String)" ")).append((Component)stateText));
            return 1;
        };
        Command messageAction = ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String message = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            PartyMessenger.sendPartyMessage(player, message);
            return 1;
        };
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pchat").requires(requirement)).then(Commands.literal((String)"toggle").executes(toggleAction))).then(Commands.literal((String)"status").executes(statusAction))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(messageAction)));
    }
}

