/*
 * Decompiled with CFR 0.152.
 */
package org.opnsoc.opac_better_commands.utils;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;

public class PartyMessenger {
    public static void sendPartyMessage(ServerPlayer sender, String text) {
        MinecraftServer server = sender.getServer();
        IServerData serverData = ServerData.from((MinecraftServer)server);
        assert (serverData != null);
        IPartyManager partyManager = serverData.getPartyManager();
        IServerParty party = partyManager.getPartyByMember(sender.getUUID());
        if (party == null) {
            sender.sendSystemMessage((Component)Component.literal((String)"You are not in a party!").withStyle(ChatFormatting.RED));
            return;
        }
        IPartyMember senderInfo = party.getMemberInfo(sender.getUUID());
        MutableComponent rankComponent = Component.literal((String)((party.getOwner() == senderInfo ? "OWNER" : Objects.requireNonNull(senderInfo).getRank().toString()) + " ")).withStyle(s -> s.withColor(senderInfo.getRank().getColor()));
        MutableComponent nameComponent = Component.literal((String)("<" + sender.getName().getString() + "> ")).withStyle(ChatFormatting.WHITE);
        MutableComponent contentComponent = Component.literal((String)text).withStyle(s -> s.withColor(ChatFormatting.GRAY));
        MutableComponent messageComponent = Component.literal((String)"");
        messageComponent.getSiblings().add(rankComponent);
        messageComponent.getSiblings().add(nameComponent);
        messageComponent.getSiblings().add(contentComponent);
        new PartyOnCommandUpdater().update(sender.getUUID(), serverData, party, serverData.getPlayerConfigs(), mi -> false, (Component)messageComponent);
    }
}

