/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.client.metalScanning;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import leaf.cosmere.allomancy.client.metalScanning.ScanResult;
import leaf.cosmere.allomancy.common.manifestation.AllomancyIronSteel;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.CosmereTags;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IronSteelLinesThread
implements Runnable {
    private static IronSteelLinesThread INSTANCE;
    private static Thread t;
    private static final Lock lock;
    private static ScanResult scanResult;
    private static Vec3 closestMetalObjectInLookVector;
    private final double tolerance = 1.8;
    private static int scanRange;
    private static boolean isStopping;
    TagKey<Block> aluminumOre = (TagKey)CosmereTags.Blocks.METAL_ORE_BLOCK_TAGS.get(Metals.MetalType.ALUMINUM);
    TagKey<Block> aluminumStorage = (TagKey)CosmereTags.Blocks.METAL_BLOCK_TAGS.get(Metals.MetalType.ALUMINUM);
    TagKey<Block> aluminumSheet = BlockTags.create((ResourceLocation)new ResourceLocation("sheetmetals/aluminum"));
    TagKey<Block> aluminumWire = BlockTags.create((ResourceLocation)new ResourceLocation("wires/aluminum"));

    public static IronSteelLinesThread getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IronSteelLinesThread();
        }
        return INSTANCE;
    }

    private IronSteelLinesThread() {
    }

    public static void startThread() {
        IronSteelLinesThread.getInstance().start();
    }

    public static void stopThread(boolean restart) {
        if (INSTANCE != null) {
            INSTANCE.stop();
            INSTANCE = null;
            if (restart) {
                IronSteelLinesThread.startThread();
            }
        }
    }

    public ScanResult requestScanResult() {
        lock.lock();
        try {
            return scanResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            lock.unlock();
            return new ScanResult();
        }
    }

    public int getWeight() {
        if (IronSteelLinesThread.scanResult.hasTargetedCluster) {
            return IronSteelLinesThread.scanResult.targetedCluster.getBlocks().size();
        }
        return 1;
    }

    public void releaseScanResult() {
        lock.unlock();
    }

    public void setScanRange(int range) {
        scanRange = range;
    }

    public Vec3 getClosestMetalObject() {
        if (closestMetalObjectInLookVector == null) {
            return null;
        }
        return new Vec3(closestMetalObjectInLookVector.m_7096_(), closestMetalObjectInLookVector.m_7098_(), closestMetalObjectInLookVector.m_7094_());
    }

    public void start() {
        if (t == null || isStopping) {
            CosmereAPI.logger.info("Starting lines thread");
            t = new Thread((Runnable)this, "lines_thread");
            isStopping = false;
            t.start();
        }
    }

    public void stop() {
        if (t != null && !isStopping) {
            isStopping = true;
        }
    }

    private void setScanResult(ScanResult result) {
        scanResult = result;
    }

    private void setClosestMetalObject(Vec3 vector) {
        closestMetalObjectInLookVector = vector;
    }

    private Vec3i toVec3i(Vec3 vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3i((int)vector.m_7096_(), (int)vector.m_7098_(), (int)vector.m_7094_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void run() {
        Minecraft mc = Minecraft.m_91087_();
        boolean restartThread = false;
        while (!isStopping) {
            try {
                AtomicReference<Object> closestMetalThingLookedAt = new AtomicReference<Object>(null);
                LocalPlayer playerEntity = mc.f_91074_;
                ScanResult nextScan = new ScanResult();
                BlockPos.m_121985_((BlockPos)playerEntity.m_20183_(), (int)scanRange, (int)scanRange, (int)scanRange).filter(blockPos -> {
                    boolean isGood;
                    IHasMetalType iHasMetalType;
                    Block block = playerEntity.m_9236_().m_8055_(blockPos).m_60734_();
                    boolean validMetalBlock = block instanceof IHasMetalType && (iHasMetalType = (IHasMetalType)block).getMetalType() != Metals.MetalType.ALUMINUM;
                    boolean bl = isGood = validMetalBlock || AllomancyIronSteel.containsMetal(block);
                    if (isGood) {
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        ClientLevel level = Minecraft.m_91087_().f_91073_;
                        if (player == null || mc.f_91073_ == null) {
                            IronSteelLinesThread.stopThread(false);
                            return false;
                        }
                        boolean bl2 = isGood = !this.isBlockObscured((BlockPos)blockPos, (Player)player, (Level)level);
                        if (isGood) {
                            closestMetalThingLookedAt.set(this.compareVectors((BlockPos)blockPos, (Player)player, (Vec3)closestMetalThingLookedAt.get()));
                        }
                    }
                    return isGood;
                }).forEach(blockPos -> nextScan.addBlock(blockPos.m_7949_(), (Vec3)closestMetalThingLookedAt.get()));
                Vec3 possibleClosestMetalObject = nextScan.finalizeClusters();
                if (possibleClosestMetalObject != null) {
                    closestMetalThingLookedAt.set(possibleClosestMetalObject);
                }
                EntityHelper.getEntitiesInRange((Entity)playerEntity, (int)scanRange, (boolean)false).forEach(entity -> {
                    try {
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        ClientLevel level = Minecraft.m_91087_().f_91073_;
                        if (player == null || mc.f_91073_ == null) {
                            IronSteelLinesThread.stopThread(false);
                            return;
                        }
                        if (AllomancyIronSteel.entityContainsMetal(entity) && !this.isEntityObscured((Entity)entity, (Player)player, (Level)level)) {
                            nextScan.foundEntities.add(entity.m_20182_().m_82520_(0.0, entity.m_20191_().m_82376_() / 2.0, 0.0));
                            closestMetalThingLookedAt.set(this.compareVectors(entity.m_20182_().m_82520_(0.0, entity.m_20191_().m_82376_() / 2.0, 0.0), (Player)player, (Vec3)closestMetalThingLookedAt.get()));
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                });
                if (!lock.tryLock()) continue;
                this.setScanResult(nextScan);
                this.setClosestMetalObject(closestMetalThingLookedAt.get());
                lock.unlock();
            }
            catch (Exception e) {
                CosmereAPI.logger.info("Unexpected exception in lines thread: \n" + Arrays.toString(e.getStackTrace()));
                restartThread = true;
                break;
            }
        }
        IronSteelLinesThread.stopThread(restartThread);
    }

    private boolean isBlockObscured(BlockPos blockPos, Player player, Level level) {
        Vec3 currVec = player.m_146892_();
        currVec = currVec.m_82520_(-1.0, 0.0, 0.0);
        Vec3 endPos = blockPos.m_252807_();
        endPos = endPos.m_82520_(-1.0, 0.0, 0.0);
        Vec3 endFloorVec = new Vec3(Math.floor(endPos.f_82479_), Math.floor(endPos.f_82480_), Math.floor(endPos.f_82481_));
        double resistance = 0.0;
        int loopTimes = (int)Math.ceil(currVec.m_82554_(endPos));
        for (int i = 0; i < loopTimes; ++i) {
            IHasMetalType iHasMetalType;
            BlockState bState = Objects.requireNonNull(level.m_8055_(new BlockPos(this.toVec3i(currVec))));
            Vec3 currFloorVec = new Vec3(Math.floor(currVec.f_82479_), Math.floor(currVec.f_82480_), Math.floor(currVec.f_82481_));
            if (currFloorVec.equals((Object)endFloorVec) || resistance >= 1.0) break;
            Block currBlock = bState.m_60734_();
            resistance = bState.m_204336_(this.aluminumOre) || bState.m_204336_(this.aluminumStorage) || bState.m_204336_(this.aluminumSheet) || bState.m_204336_(this.aluminumWire) || currBlock instanceof IHasMetalType && (iHasMetalType = (IHasMetalType)currBlock).getMetalType() == Metals.MetalType.DURALUMIN ? (resistance += 1.0) : (resistance += AllomancyIronSteel.getResistance(bState).doubleValue());
            double distance = currVec.m_82554_(endPos);
            currVec = currVec.m_165921_(endPos, 1.0 / distance);
        }
        boolean isObscured = resistance >= 1.0;
        return isObscured;
    }

    private boolean isEntityObscured(Entity entity, Player player, Level level) {
        double resistance = 0.0;
        try {
            Vec3 currVec = player.m_146892_();
            currVec = currVec.m_82520_(-0.75, 0.0, 0.0);
            Vec3 endPos = entity.m_20182_();
            endPos = endPos.m_82520_(-0.75, 0.0, 0.0);
            int loopTimes = (int)Math.ceil(currVec.m_82554_(endPos));
            for (int i = 0; i < loopTimes; ++i) {
                boolean pastEntity;
                BlockState bState = Objects.requireNonNull(level.m_8055_(new BlockPos(this.toVec3i(currVec))));
                boolean bl = pastEntity = player.m_146892_().m_82554_(currVec) >= player.m_146892_().m_82554_(endPos);
                if (!pastEntity && !(resistance >= 1.0)) {
                    IHasMetalType iHasMetalType;
                    Block currBlock = level.m_8055_(new BlockPos(this.toVec3i(currVec))).m_60734_();
                    resistance = bState.m_204336_(this.aluminumOre) || bState.m_204336_(this.aluminumStorage) || bState.m_204336_(this.aluminumSheet) || bState.m_204336_(this.aluminumWire) || currBlock instanceof IHasMetalType && (iHasMetalType = (IHasMetalType)currBlock).getMetalType() == Metals.MetalType.DURALUMIN ? (resistance += 1.0) : (resistance += AllomancyIronSteel.getResistance(bState).doubleValue());
                    double distance = currVec.m_82554_(endPos);
                    currVec = currVec.m_165921_(endPos, 1.0 / distance);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resistance = 100.0;
        }
        return !(resistance < 1.0);
    }

    private Vec3 compareVectors(BlockPos blockPos, Player player, Vec3 currentClosestMetalObject) {
        Vec3 lookVector = player.m_20154_();
        Vec3 vectorToPos = blockPos.m_252807_().m_82546_(player.m_146892_());
        Vec3 playerPos = player.m_146892_();
        vectorToPos = vectorToPos.m_82541_();
        double dynamicTolerance = 1.8 / playerPos.m_82554_(blockPos.m_252807_());
        if (vectorToPos.m_82554_(lookVector) < dynamicTolerance) {
            if (currentClosestMetalObject == null) {
                return blockPos.m_252807_();
            }
            Vec3 currentVector = currentClosestMetalObject.m_82546_(player.m_146892_());
            currentVector = currentVector.m_82541_();
            if (vectorToPos.m_82554_(lookVector) > currentVector.m_82554_(lookVector)) {
                return currentClosestMetalObject;
            }
            return blockPos.m_252807_();
        }
        return currentClosestMetalObject;
    }

    private Vec3 compareVectors(Vec3 pos, Player player, Vec3 currentClosestMetalObject) {
        Vec3 lookVector = player.m_20154_();
        Vec3 vectorToPos = pos.m_82546_(player.m_146892_());
        Vec3 playerPos = player.m_146892_();
        vectorToPos = vectorToPos.m_82541_();
        double dynamicTolerance = 1.8 / playerPos.m_82554_(pos);
        if (vectorToPos.m_82554_(lookVector) < dynamicTolerance) {
            if (currentClosestMetalObject == null) {
                return pos;
            }
            Vec3 currentVector = currentClosestMetalObject.m_82546_(player.m_146892_());
            currentVector = currentVector.m_82541_();
            if (vectorToPos.m_82554_(lookVector) > currentVector.m_82554_(lookVector)) {
                return currentClosestMetalObject;
            }
            return pos;
        }
        return currentClosestMetalObject;
    }

    static {
        lock = new ReentrantLock();
        scanResult = new ScanResult();
        scanRange = 0;
        isStopping = false;
    }
}

