/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.capabilities.world;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nonnull;
import leaf.cosmere.allomancy.common.capabilities.world.IScadrial;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.math.Easing;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.fog.FogManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class ScadrialCapability
implements IScadrial {
    public static final Capability<IScadrial> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IScadrial>(){});
    Level level;
    CompoundTag nbt = null;

    public ScadrialCapability(Level level) {
        this.level = level;
    }

    @Nonnull
    public static LazyOptional<IScadrial> get(Level level) {
        return level != null ? level.getCapability(CAPABILITY, null) : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        if (this.nbt == null) {
            this.nbt = new CompoundTag();
        }
        return this.nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.nbt = nbt;
    }

    private boolean isMistNight() {
        int day = (int)(this.level.m_46468_() / 24000L % Integer.MAX_VALUE);
        if (day < 2) {
            return false;
        }
        if (day % 2 == 0) {
            return day == 2;
        }
        int i = 3;
        while (i * i <= day) {
            if (day % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    @Override
    public float getMistNearDistance() {
        float i;
        long timeOfDay = this.level.m_46468_() % 24000L;
        float easeTime = 3500.0f;
        float fogInStartTime = 11500.0f;
        float fogInEndTime = 15000.0f;
        float fogOutStartTime = 20499.0f;
        float fogOutEndTime = 23999.0f;
        if ((float)timeOfDay <= 11500.0f || (float)timeOfDay >= 23999.0f) {
            return 0.9f;
        }
        if ((float)timeOfDay < 15000.0f) {
            float percentageThroughFogTransition = ((float)timeOfDay - 11500.0f) / 3500.0f;
            i = Easing.easeOutQuad((float)percentageThroughFogTransition);
        } else {
            if ((float)timeOfDay < 20499.0f) {
                return 0.0f;
            }
            float percentageThroughFogTransition = ((float)timeOfDay - 20499.0f) / 3500.0f;
            i = 1.0f - Easing.easeInQuad((float)percentageThroughFogTransition);
        }
        return Mth.m_14179_((float)i, (float)0.9f, (float)0.0f);
    }

    @Override
    public float getMistFarDistance() {
        float i;
        long timeOfDay = this.level.m_46468_() % 24000L;
        float easeTime = 3500.0f;
        float fogInStartTime = 12500.0f;
        float fogInEndTime = 16000.0f;
        float fogOutStartTime = 19500.0f;
        if ((float)timeOfDay <= 12500.0f) {
            return 1.0f;
        }
        if ((float)timeOfDay < 16000.0f) {
            float percentageThroughFogTransition = ((float)timeOfDay - 12500.0f) / 3500.0f;
            i = Easing.easeOutQuad((float)percentageThroughFogTransition);
        } else {
            if ((float)timeOfDay < 19500.0f) {
                return 0.1f;
            }
            float percentageThroughFogTransition = ((float)timeOfDay - 19500.0f) / 3500.0f;
            i = 1.0f - Easing.easeInQuad((float)percentageThroughFogTransition);
        }
        return Mth.m_14179_((float)i, (float)1.0f, (float)0.1f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickFog(ViewportEvent.RenderFog event, Player player) {
        FogManager densityManager = FogManager.getDensityManager();
        float mistNearDistance = this.getMistNearDistance();
        float mistFarDistance = this.getMistFarDistance();
        float startFogDistance = 0.9f;
        float endFogDistance = 1.0f;
        if (this.isMistNight()) {
            float tinAlloVal = 0.0f;
            LazyOptional iSpiritwebLazyOptional = SpiritwebCapability.get((LivingEntity)player);
            if (iSpiritwebLazyOptional.isPresent()) {
                Object t;
                Optional spiritweb = iSpiritwebLazyOptional.resolve();
                AllomancyManifestation tinAllomancy = (AllomancyManifestation)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.TIN).get());
                if (spiritweb.isPresent() && (t = spiritweb.get()) instanceof SpiritwebCapability) {
                    SpiritwebCapability data = (SpiritwebCapability)t;
                    if (tinAllomancy != null && tinAllomancy.isMetalBurning((ISpiritweb)data)) {
                        double currentBurnStrength = tinAllomancy.getStrength((ISpiritweb)data, false) * (double)data.getMode((Manifestation)tinAllomancy);
                        RangedAttribute attribute = (RangedAttribute)tinAllomancy.getAttribute();
                        double maxTinFlareStrengthPossible = attribute.m_147362_() * 2.0;
                        tinAlloVal = (float)Mth.m_14139_((double)(currentBurnStrength / maxTinFlareStrengthPossible), (double)0.0, (double)0.95f);
                    }
                }
            }
            startFogDistance = Mth.m_14036_((float)(mistNearDistance + tinAlloVal), (float)0.0f, (float)1.0f);
            endFogDistance = Mth.m_14036_((float)(mistFarDistance + tinAlloVal), (float)0.0f, (float)1.0f);
        }
        densityManager.fogStart.setDefaultValue(startFogDistance);
        densityManager.fogEnd.setDefaultValue(endFogDistance);
        float renderDistance = event.getRenderer().m_109152_();
        float pShaderFogStart = renderDistance * densityManager.fogStart.get((float)event.getPartialTick());
        float pShaderFogEnd = renderDistance * densityManager.fogEnd.get((float)event.getPartialTick());
        RenderSystem.setShaderFogStart((float)pShaderFogStart);
        RenderSystem.setShaderFogEnd((float)pShaderFogEnd);
        RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
    }
}

