/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import leaf.cosmere.allomancy.common.capabilities.AllomancySpiritwebSubmodule;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;

public class AllomancyAluminum
extends AllomancyManifestation {
    public AllomancyAluminum(Metals.MetalType metalType) {
        super(metalType);
    }

    protected void applyEffectTick(ISpiritweb data) {
        if (this.isActiveTick(data)) {
            int drainedCount = 0;
            for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
                if (metalType == Metals.MetalType.ALUMINUM || !this.drainMetal(data, metalType)) continue;
                ++drainedCount;
            }
            if (drainedCount <= 0) {
                this.drainMetal(data, Metals.MetalType.ALUMINUM);
            }
            data.syncToClients(null);
        }
    }

    private boolean drainMetal(ISpiritweb data, Metals.MetalType metalType) {
        AllomancySpiritwebSubmodule allo = (AllomancySpiritwebSubmodule)((SpiritwebCapability)data).getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY);
        int ingestedMetalAmount = allo.getIngestedMetal(metalType);
        if (ingestedMetalAmount > 0) {
            int amountToAdjust = ingestedMetalAmount > 30 ? ingestedMetalAmount / 2 : ingestedMetalAmount;
            allo.adjustIngestedMetal(metalType, -amountToAdjust, true);
            return true;
        }
        return false;
    }
}

