/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import leaf.cosmere.allomancy.client.metalScanning.IronSteelLinesThread;
import leaf.cosmere.allomancy.common.Allomancy;
import leaf.cosmere.allomancy.common.config.AllomancyConfigs;
import leaf.cosmere.allomancy.common.entities.CoinProjectile;
import leaf.cosmere.allomancy.common.items.CoinPouchItem;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.CosmereTags;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.CodecHelper;
import leaf.cosmere.api.helpers.RegistryHelper;
import leaf.cosmere.api.math.VectorHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.network.packets.SyncPushPullMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public class AllomancyIronSteel
extends AllomancyManifestation {
    public static final HashMap<TagKey<Block>, Double> materialResistanceMap = AllomancyIronSteel.initHashMap();
    private final boolean isPush;
    private static Set<String> s_whiteList = null;
    private static Set<String> s_blackList = null;

    public AllomancyIronSteel(Metals.MetalType metalType) {
        super(metalType);
        this.isPush = metalType == Metals.MetalType.STEEL;
    }

    private static HashMap<TagKey<Block>, Double> initHashMap() {
        HashMap<TagKey<Block>, Double> output = new HashMap<TagKey<Block>, Double>();
        output.put(BlockTags.f_144282_, 0.5);
        output.put(BlockTags.f_144283_, 0.2);
        output.put(BlockTags.f_144280_, 0.25);
        return output;
    }

    public static Double getResistance(BlockState blockState) {
        Double retValue = 0.0;
        for (TagKey<Block> tagKey : materialResistanceMap.keySet()) {
            if (!blockState.m_204336_(tagKey)) continue;
            retValue = materialResistanceMap.get(tagKey);
            break;
        }
        return retValue;
    }

    public void applyEffectTick(ISpiritweb data) {
        if (data.getLiving().m_9236_().f_46443_) {
            this.performEffectClient(data);
        } else {
            this.performEffectServer(data);
        }
    }

    @Override
    public void onModeChange(ISpiritweb cap, int lastMode) {
        if (cap.getLiving().m_9236_().f_46443_) {
            super.onModeChange(cap, lastMode);
            if (this.getMode(cap) != 0) {
                if (this.getMode(cap) > 0) {
                    IronSteelLinesThread.startThread();
                } else if (this.getMode(cap) <= 0) {
                    IronSteelLinesThread.stopThread(false);
                }
                return;
            }
            SpiritwebCapability data = (SpiritwebCapability)cap;
            List blocks = this.isPush ? data.pushBlocks : data.pullBlocks;
            List entities = this.isPush ? data.pushEntities : data.pullEntities;
            blocks.clear();
            entities.clear();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void performEffectClient(ISpiritweb cap) {
        List entities;
        boolean hasChanged = false;
        SpiritwebCapability data = (SpiritwebCapability)cap;
        List blocks = this.isPush ? data.pushBlocks : data.pullBlocks;
        List list = entities = this.isPush ? data.pushEntities : data.pullEntities;
        if (s_whiteList == null) {
            AllomancyIronSteel.createWhitelist((Entity)cap.getLiving());
        }
        if (this.getKeyBinding().m_90857_()) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            ClientLevel level = mc.f_91073_;
            boolean hitEntity = false;
            Entity entityHitResult = null;
            Vec3 closestMetalObjectVec3 = IronSteelLinesThread.getInstance().getClosestMetalObject();
            BlockPos closestMetalObject = null;
            if (closestMetalObjectVec3 != null) {
                closestMetalObject = BlockPos.m_274446_((Position)closestMetalObjectVec3);
            }
            if (closestMetalObject != null) {
                BlockState blockAtPos = level.m_8055_(closestMetalObject);
                if (blockAtPos.m_60795_()) {
                    try {
                        AABB aabb = new AABB(closestMetalObject);
                        Entity firstMetalEntity = null;
                        for (Entity ent : level.m_6249_((Entity)player, aabb, potentialEntityHit -> !potentialEntityHit.m_5833_())) {
                            if (!AllomancyIronSteel.entityContainsMetal(ent)) continue;
                            firstMetalEntity = ent;
                            break;
                        }
                        boolean bl = hitEntity = firstMetalEntity != null && AllomancyIronSteel.entityContainsMetal(firstMetalEntity);
                        if (hitEntity) {
                            entityHitResult = firstMetalEntity;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        hitEntity = false;
                    }
                }
                if (hitEntity) {
                    hasChanged = this.trackValidEntity((ISpiritweb)data, entityHitResult);
                } else {
                    blocks.add(closestMetalObject);
                    if (blocks.size() > 5) {
                        blocks.remove(0);
                    }
                    hasChanged = true;
                }
            }
        } else {
            if (!blocks.isEmpty()) {
                blocks.clear();
                hasChanged = true;
            }
            if (!entities.isEmpty()) {
                entities.clear();
                hasChanged = true;
            }
        }
        if (hasChanged) {
            CompoundTag nbt = new CompoundTag();
            CodecHelper.BlockPosListCodec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)blocks).resultOrPartial(arg_0 -> ((Logger)CosmereAPI.logger).error(arg_0)).ifPresent(inbt1 -> nbt.m_128365_(this.isPush ? "pushBlocks" : "pullBlocks", inbt1));
            nbt.m_128408_(this.isPush ? "pushEntities" : "pullEntities", entities);
            nbt.m_128405_("weight", IronSteelLinesThread.getInstance().getWeight());
            Allomancy.packetHandler().sendToServer(new SyncPushPullMessage(nbt));
        }
    }

    public boolean trackValidEntity(ISpiritweb cap, Entity entity) {
        List entities;
        SpiritwebCapability data = (SpiritwebCapability)cap;
        List list = entities = this.isPush ? data.pushEntities : data.pullEntities;
        if (!entities.contains(entity.m_19879_()) && AllomancyIronSteel.entityContainsMetal(entity)) {
            entities.add(entity.m_19879_());
            if (entities.size() > 5) {
                entities.remove(0);
            }
            return true;
        }
        return false;
    }

    private void performEffectServer(ISpiritweb cap) {
        List entities;
        if (cap.getLiving().f_19797_ % 3 == 0) {
            return;
        }
        SpiritwebCapability data = (SpiritwebCapability)cap;
        List blocks = this.isPush ? data.pushBlocks : data.pullBlocks;
        List list = entities = this.isPush ? data.pushEntities : data.pullEntities;
        if (!blocks.isEmpty()) {
            this.pushpullBlocks(data);
        }
        if (!entities.isEmpty()) {
            this.pushpullEntities(data);
        }
    }

    private void pushpullEntities(SpiritwebCapability data) {
        List entities = this.isPush ? data.pushEntities : data.pullEntities;
        int weight = data.pushPullWeight;
        for (int i = entities.size() - 1; i >= 0; --i) {
            int entityID = (Integer)entities.get(i);
            LivingEntity dataLiving = data.getLiving();
            Entity targetEntity = dataLiving.m_9236_().m_6815_(entityID);
            if (targetEntity != null) {
                Player player;
                if (!targetEntity.m_20183_().m_123314_((Vec3i)dataLiving.m_20183_(), (double)this.getRange((ISpiritweb)data))) continue;
                if (targetEntity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)targetEntity;
                    if (dataLiving instanceof Player) {
                        player = (Player)dataLiving;
                        if (!this.isPush) {
                            itemEntity.m_6123_(player);
                            continue;
                        }
                    }
                    this.moveEntityTowards((Entity)itemEntity, dataLiving.m_20183_(), weight);
                    continue;
                }
                if (targetEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)targetEntity;
                    this.moveEntityTowards((Entity)livingEntity, dataLiving.m_20183_(), weight);
                    this.moveEntityTowards((Entity)dataLiving, livingEntity.m_20183_(), weight);
                    dataLiving.f_19864_ = true;
                    continue;
                }
                if (this.isPush) {
                    this.moveEntityTowards((Entity)dataLiving, targetEntity.m_20183_(), weight);
                    continue;
                }
                if (!(dataLiving instanceof Player)) continue;
                player = (Player)dataLiving;
                if (!(targetEntity instanceof CoinProjectile)) continue;
                CoinProjectile coinProjectile = (CoinProjectile)targetEntity;
                CoinPouchItem.onPickupItem((Entity)coinProjectile, player);
                continue;
            }
            entities.remove(i);
        }
    }

    private void moveEntityTowards(Entity entity, BlockPos toMoveTo, int weight) {
        Vec3 blockCenter = toMoveTo.m_252807_();
        Vec3 direction = VectorHelper.getDirection((Vec3)blockCenter, (Vec3)entity.m_20183_().m_252807_(), (float)(this.isPush ? -1.0f : 2.0f));
        Vec3 normalize = direction.m_82541_();
        double shortenFactor = this.isPush ? 0.2 : 0.4;
        Vec3 add = entity.m_20184_().m_82549_(normalize.m_82542_(shortenFactor, shortenFactor, shortenFactor));
        double adjustedWeight = 1.0 + Math.min((Double)AllomancyConfigs.SERVER.MAX_PUSH_PULL_WEIGHT.get(), (double)(weight - 1) * (Double)AllomancyConfigs.SERVER.PUSH_PULL_WEIGHT.get());
        entity.m_8127_();
        entity.m_20256_(VectorHelper.ClampMagnitude((Vec3)add, (float)1.0f).m_82542_(adjustedWeight, adjustedWeight, adjustedWeight));
        entity.f_19864_ = true;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.f_19789_ = Math.min(player.f_19789_, 1.0f);
        }
    }

    private void pushpullBlocks(SpiritwebCapability data) {
        List blocks = this.isPush ? data.pushBlocks : data.pullBlocks;
        int weight = data.pushPullWeight;
        int blockListCount = blocks.size();
        if (blockListCount == 0) {
            return;
        }
        LivingEntity living = data.getLiving();
        for (int i = blockListCount - 1; i >= 0; --i) {
            BlockPos blockPos = (BlockPos)blocks.get(i);
            if (!this.isPush && blockPos.m_123333_((Vec3i)living.m_20183_()) < 2) continue;
            double maxDistance = this.getRange((ISpiritweb)data);
            if (!blockPos.m_123314_((Vec3i)living.m_20183_(), maxDistance)) continue;
            this.moveEntityTowards((Entity)living, blockPos, weight);
        }
        living.f_19864_ = true;
    }

    public static boolean entityContainsMetal(Entity entity) {
        if (AllomancyIronSteel.containsMetal(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (AllomancyIronSteel.containsMetal(livingEntity.m_21205_()) || AllomancyIronSteel.containsMetal(livingEntity.m_21206_())) {
                return true;
            }
            for (ItemStack itemStack : livingEntity.m_6168_()) {
                if (!AllomancyIronSteel.containsMetal(itemStack.m_41720_())) continue;
                return true;
            }
            return false;
        }
        if (entity instanceof ItemEntity) {
            BlockItem blockItem;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.m_32055_();
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && AllomancyIronSteel.containsMetal((blockItem = (BlockItem)item).m_40614_())) {
                return true;
            }
            boolean validMetalItem = AllomancyIronSteel.containsMetal(item);
            return validMetalItem;
        }
        if (entity instanceof CoinProjectile) {
            CoinProjectile coinProjectile = (CoinProjectile)entity;
            return true;
        }
        return false;
    }

    public static boolean containsMetal(ItemStack itemStack) {
        return AllomancyIronSteel.containsMetal(itemStack.m_41720_());
    }

    public static boolean containsMetal(Item item) {
        if (item.m_204114_().m_203656_(CosmereTags.Items.CONTAINS_METAL)) {
            return true;
        }
        if (s_whiteList == null) {
            return false;
        }
        return s_whiteList.contains(RegistryHelper.get((Item)item).m_135815_());
    }

    public static boolean containsMetal(Block block) {
        if (block.m_204297_().m_203656_(CosmereTags.Blocks.CONTAINS_METAL)) {
            return true;
        }
        if (s_whiteList == null) {
            return false;
        }
        return s_whiteList.contains(RegistryHelper.get((Block)block).m_135815_());
    }

    public static boolean containsMetal(Entity entity) {
        if (entity.m_6095_().m_204039_(CosmereTags.EntityTypes.CONTAINS_METAL)) {
            return true;
        }
        if (s_whiteList == null) {
            return false;
        }
        return s_whiteList.contains(RegistryHelper.get((Entity)entity).m_135815_());
    }

    public static void invalidateWhitelist() {
        s_whiteList = null;
    }

    private static void createWhitelist(Entity entity) {
        if (s_whiteList != null) {
            return;
        }
        s_blackList = new HashSet<String>();
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50016_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_49990_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_49991_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50440_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50093_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50058_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50185_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50029_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50026_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50025_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50028_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50023_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50021_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50027_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50017_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50022_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50019_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50068_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50067_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50020_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50024_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50066_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50018_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50081_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50456_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50126_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50568_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50449_).m_135815_());
        s_blackList.add(RegistryHelper.get((Block)Blocks.f_50354_).m_135815_());
        s_blackList.add(RegistryHelper.get((Item)Items.f_42415_).m_135815_());
        s_blackList.add(RegistryHelper.get((Item)Items.f_42616_).m_135815_());
        s_blackList.add(RegistryHelper.get((Item)Items.f_41852_).m_135815_());
        s_blackList.add("philosophers_stone");
        for (String itemInList : s_blackList) {
            CosmereAPI.logger.info("[MetalWhitelist] %s has been blacklisted from containing metal".formatted(itemInList));
        }
        s_whiteList = new HashSet<String>();
        TagKey containsMetal = CosmereTags.Items.CONTAINS_METAL;
        RecipeManager recipeManager = entity.m_9236_().m_7465_();
        Collection recipes = recipeManager.m_44051_();
        for (Recipe recipe : recipes) {
            ItemStack resultItem = recipe.m_8043_(entity.m_9236_().m_9598_());
            if (resultItem == null || resultItem.m_41619_() || s_blackList.contains(RegistryHelper.get((Item)resultItem.m_41720_()).m_135815_()) || resultItem.m_204117_(containsMetal)) continue;
            AllomancyIronSteel.CheckRecipeForMetal((TagKey<Item>)containsMetal, recipe, resultItem);
        }
    }

    public static void CheckRecipeForMetal(TagKey<Item> containsMetal, Recipe<?> recipe, ItemStack resultItemStack) {
        for (Ingredient ingredient : recipe.m_7527_()) {
            for (ItemStack ingredientStack : ingredient.m_43908_()) {
                Item ingredientItem = ingredientStack.m_41720_();
                ResourceLocation ingredientItemRL = RegistryHelper.get((Item)ingredientItem);
                if (s_blackList.contains(ingredientItemRL.m_135815_()) || !ingredientStack.m_204117_(containsMetal)) continue;
                Item resultItem = resultItemStack.m_41720_();
                ResourceLocation resultItemRL = RegistryHelper.get((Item)resultItem);
                CosmereAPI.logger.info("[MetalWhitelist] %s has been identified as containing metal, thanks to %s in recipe".formatted(resultItemRL, ingredientItemRL));
                s_whiteList.add(resultItemRL.m_135815_());
                return;
            }
        }
    }

    @Override
    public int getRange(ISpiritweb data) {
        if (!this.isActive(data)) {
            return 0;
        }
        double allomanticStrength = this.getStrength(data, false);
        double potentialRange = (double)Math.max(this.getMode(data), 0) * allomanticStrength;
        return Mth.m_14107_((double)(potentialRange * (Double)AllomancyConfigs.SERVER.IRON_STEEL_RANGE.get()));
    }
}

