/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import leaf.cosmere.allomancy.client.AllomancyKeybindings;
import leaf.cosmere.allomancy.common.capabilities.AllomancySpiritwebSubmodule;
import leaf.cosmere.allomancy.common.registries.AllomancyStats;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.charge.MetalmindChargeHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AllomancyManifestation
extends Manifestation
implements IHasMetalType {
    private final Metals.MetalType metalType;

    public AllomancyManifestation(Metals.MetalType metalType) {
        super(Manifestations.ManifestationTypes.ALLOMANCY);
        this.metalType = metalType;
    }

    public int getPowerID() {
        return this.metalType.getID();
    }

    public boolean modeWraps(ISpiritweb data) {
        return true;
    }

    public Metals.MetalType getMetalType() {
        return this.metalType;
    }

    public int modeMax(ISpiritweb data) {
        return 2;
    }

    public void onModeChange(ISpiritweb data, int lastMode) {
        super.onModeChange(data, lastMode);
        if (Mth.m_14040_((int)this.getMode(data)) != 0) {
            return;
        }
        LivingEntity livingEntity = data.getLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_7166_(Stats.f_12988_.m_12902_((Object)this.getBurnTimeStat()));
        }
    }

    public int modeMin(ISpiritweb data) {
        ResourceLocation feruchemyRL = new ResourceLocation("feruchemy", this.getRegistryName().m_135815_());
        Manifestation feruchemy = (Manifestation)CosmereAPI.manifestationRegistry().getValue(feruchemyRL);
        if (data.hasManifestation(feruchemy)) {
            return -2;
        }
        return 0;
    }

    public boolean isActive(ISpiritweb data) {
        return super.isActive(data) && this.isMetalBurning(data);
    }

    public boolean isCompounding(ISpiritweb data) {
        return this.isMetalBurning(data) && this.getMode(data) < 0;
    }

    public boolean isAllomanticBurn(ISpiritweb data) {
        return this.isMetalBurning(data) && this.getMode(data) > 0;
    }

    public boolean isMetalBurning(ISpiritweb data) {
        int modeAbs = Mth.m_14040_((int)this.getMode(data));
        AllomancySpiritwebSubmodule allo = (AllomancySpiritwebSubmodule)((SpiritwebCapability)data).getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY);
        while (modeAbs > 0) {
            if (allo.adjustIngestedMetal(this.metalType, -modeAbs, false)) {
                return true;
            }
            data.setMode((Manifestation)this, --modeAbs);
        }
        return false;
    }

    protected boolean isFlaring(ISpiritweb data) {
        int mode = this.getMode(data);
        int absMode = Mth.m_14040_((int)mode);
        return absMode > 1;
    }

    public boolean tick(ISpiritweb data) {
        if (!this.isActive(data)) {
            return false;
        }
        int mode = this.getMode(data);
        int cost = Mth.m_14040_((int)mode);
        AllomancySpiritwebSubmodule allo = (AllomancySpiritwebSubmodule)((SpiritwebCapability)data).getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY);
        LivingEntity livingEntity = data.getLiving();
        boolean isActiveTick = this.isActiveTick(data);
        allo.adjustIngestedMetal(this.metalType, -cost, isActiveTick);
        if (isActiveTick && livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_36220_(this.getBurnTimeStat());
        }
        if (mode > 0) {
            this.applyEffectTick(data);
            return true;
        }
        if (isActiveTick) {
            this.tickCompounding(data, cost);
            return true;
        }
        return false;
    }

    private void tickCompounding(ISpiritweb data, int allomanticSecondsUsed) {
        ItemStack metalmindStack;
        double compoundStrength;
        int secondsOfFeruchemyToAdd;
        Manifestation feruchemyManifestation = (Manifestation)CosmereAPI.manifestationRegistry().getValue(new ResourceLocation("feruchemy", this.getRegistryName().m_135815_()));
        if (!data.hasManifestation(feruchemyManifestation) || (secondsOfFeruchemyToAdd = (int)(Mth.m_14154_((float)((float)Math.floor(compoundStrength = this.getStrength(data, false) * (double)Mth.m_14040_((int)allomanticSecondsUsed)))) - 5.0f)) <= 0 || !(metalmindStack = MetalmindChargeHelper.adjustMetalmindChargeExact((ISpiritweb)data, (Metals.MetalType)this.metalType, (int)secondsOfFeruchemyToAdd, (boolean)true, (boolean)true)).m_41619_()) {
            // empty if block
        }
    }

    private ResourceLocation getBurnTimeStat() {
        ResourceLocation resourceLocation = (ResourceLocation)AllomancyStats.ALLOMANCY_BURN_TIME.get(this.metalType).get();
        Stat doot = Stats.f_12988_.m_12899_((Object)resourceLocation, StatFormatter.f_12876_);
        return resourceLocation;
    }

    protected KeyMapping getKeyBinding() {
        if (this.getMetalType().isPullMetal()) {
            return AllomancyKeybindings.ALLOMANCY_IRON_PULL;
        }
        if (this.getMetalType().isPushMetal()) {
            return AllomancyKeybindings.ALLOMANCY_STEEL_PUSH;
        }
        return null;
    }

    public int getRange(ISpiritweb data) {
        if (!this.isActive(data)) {
            return 0;
        }
        double allomanticStrength = this.getStrength(data, false);
        int mode = Math.max(this.getMode(data), 0);
        return Mth.m_14107_((double)(allomanticStrength * (double)mode));
    }
}

