/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import leaf.cosmere.allomancy.common.capabilities.AllomancySpiritwebSubmodule;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.registries.AllomancyDamageTypesRegistry;
import leaf.cosmere.allomancy.common.registries.AllomancyEffects;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.helpers.EffectsHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class AllomancyPewter
extends AllomancyManifestation {
    public AllomancyPewter(Metals.MetalType metalType) {
        super(metalType);
    }

    protected void applyEffectTick(ISpiritweb data) {
        LivingEntity livingEntity = data.getLiving();
        double strength = this.getStrength(data, false);
        int actionableStrength = (int)Math.round(strength) * this.getMode(data);
        data.addEffect(EffectsHelper.getNewEffect((CosmereEffect)AllomancyEffects.ALLOMANTIC_PEWTER.getEffect(), (Entity)livingEntity, (double)actionableStrength));
        AllomancySpiritwebSubmodule asm = AllomancySpiritwebSubmodule.getSubmodule(data);
        if (asm.getPewterDelayedDamage() > 0.0f && this.getActiveTick(data) % 1200 == 0) {
            asm.setPewterDelayedDamage(asm.getPewterDelayedDamage() - 1.0f);
        }
    }

    @Override
    public void onModeChange(ISpiritweb data, int lastMode) {
        super.onModeChange(data, lastMode);
        if (data.getLiving().m_9236_().f_46443_ || data.getMode((Manifestation)this) > 0) {
            return;
        }
        data.removeEffect(EffectsHelper.getEffectUUID((CosmereEffect)AllomancyEffects.ALLOMANTIC_PEWTER.getEffect(), (Entity)data.getLiving()));
        AllomancySpiritwebSubmodule asm = AllomancySpiritwebSubmodule.getSubmodule(data);
        float delayedDamage = asm.getPewterDelayedDamage();
        data.getLiving().m_6469_(AllomancyDamageTypesRegistry.PEWTER_DELAYED_DAMAGE.source(data.getLiving().m_9236_()), delayedDamage);
        asm.setPewterDelayedDamage(0.0f);
    }

    public static void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        SpiritwebCapability.get((LivingEntity)livingEntity).ifPresent(data -> {
            AllomancyPewter pewter = (AllomancyPewter)((Object)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.PEWTER).get()));
            if (pewter.isAllomanticBurn((ISpiritweb)data)) {
                float damage = event.getAmount();
                float damageReductionMultiplier = 0.5f;
                if (damage > livingEntity.m_21223_() && pewter.isFlaring((ISpiritweb)data)) {
                    damageReductionMultiplier = 0.1f;
                }
                float newDamageAmount = damage * damageReductionMultiplier;
                float delayedDamage = damage - newDamageAmount;
                event.setAmount(damage - newDamageAmount);
                AllomancySpiritwebSubmodule asm = (AllomancySpiritwebSubmodule)data.getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY);
                asm.setPewterDelayedDamage(asm.getPewterDelayedDamage() + delayedDamage);
            }
        });
    }
}

