/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.client;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.Activator;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.client.Keybindings;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="allomancy", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AllomancyKeybindings {
    public static KeyMapping ALLOMANCY_STEEL_PUSH;
    public static KeyMapping ALLOMANCY_IRON_PULL;
    public static KeyMapping ALLOMANCY_SOOTHE;
    public static KeyMapping ALLOMANCY_RIOT;
    public static final Map<Metals.MetalType, KeyMapping> ALLOMANCY_POWER;

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        ALLOMANCY_STEEL_PUSH = new KeyMapping("key.cosmere.allomancy.push", 258, "keys.cosmere.main");
        event.register(ALLOMANCY_STEEL_PUSH);
        ALLOMANCY_IRON_PULL = new KeyMapping("key.cosmere.allomancy.pull", 82, "keys.cosmere.main");
        event.register(ALLOMANCY_IRON_PULL);
        ALLOMANCY_SOOTHE = new KeyMapping("key.cosmere.allomancy.soothe", -1, "keys.cosmere.main");
        event.register(ALLOMANCY_SOOTHE);
        ALLOMANCY_RIOT = new KeyMapping("key.cosmere.allomancy.riot", -1, "keys.cosmere.main");
        event.register(ALLOMANCY_RIOT);
        for (Metals.MetalType metalType : ALLOMANCY_POWER.keySet()) {
            KeyMapping key = ALLOMANCY_POWER.get(metalType);
            AllomancyManifestation manifest = (AllomancyManifestation)AllomancyManifestations.ALLOMANCY_POWERS.get(metalType).getManifestation();
            event.register(key);
            Activator entry = new Activator(key, (Manifestation)manifest);
            entry.setCategory("allomancy");
            Keybindings.activators.add(entry);
        }
    }

    static {
        ALLOMANCY_POWER = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasAssociatedManifestation).collect(Collectors.toMap(Function.identity(), metalType -> new KeyMapping("key.cosmere.allomancy." + metalType.m_6082_(), -1, "keys.cosmere.activators")));
    }
}

