/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.client.metalScanning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class BlockScanResult {
    private AABB bounds;
    @Nullable
    private BlockScanResult parent;
    private final Set<BlockPos> blocks;

    public BlockScanResult(BlockPos pos) {
        this.bounds = new AABB(pos);
        this.blocks = new HashSet<BlockPos>();
        this.blocks.add(pos);
    }

    boolean isRoot() {
        return this.parent == null;
    }

    public BlockScanResult getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public void setRoot(BlockScanResult root) {
        if (root == this) {
            return;
        }
        assert (this.parent == null);
        root.bounds = root.bounds.m_82367_(this.bounds);
        root.blocks.addAll(this.blocks);
        this.blocks.clear();
        this.parent = root;
    }

    public void add(BlockPos pos) {
        assert (this.parent == null) : "Trying to add to non-root node.";
        this.bounds = this.bounds.m_82367_(new AABB(pos));
        this.blocks.add(pos);
    }

    @Nullable
    public AABB getRenderBounds() {
        return this.bounds;
    }

    public Vec3 getPosition() {
        return this.bounds.m_82399_();
    }

    public ArrayList<BlockPos> getBlocks() {
        return new ArrayList<BlockPos>(this.blocks);
    }
}

