/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.client.metalScanning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import leaf.cosmere.allomancy.client.metalScanning.BlockScanResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;

public final class ScanResult {
    public final List<Vec3> foundEntities = new ArrayList<Vec3>();
    public final List<BlockPos> foundBlocks = new ArrayList<BlockPos>();
    public BlockScanResult targetedCluster = null;
    public boolean hasTargetedCluster = false;
    public final List<BlockScanResult> clusterResults = new ArrayList<BlockScanResult>();
    private final Map<BlockPos, BlockScanResult> clusters = new HashMap<BlockPos, BlockScanResult>();
    public List<Vec3> clusterCenters = new ArrayList<Vec3>();

    public void Clear() {
        this.foundEntities.clear();
        this.foundBlocks.clear();
        this.clusterResults.clear();
        this.clusters.clear();
    }

    public void addBlock(BlockPos blockPos, Vec3 currentClosestMetalObject) {
        this.foundBlocks.add(blockPos);
        if (!this.tryAddToCluster(this.clusters, blockPos, currentClosestMetalObject)) {
            BlockScanResult result = new BlockScanResult(blockPos);
            this.clusters.put(blockPos, result);
            this.clusterResults.add(result);
        }
    }

    private boolean tryAddToCluster(Map<BlockPos, BlockScanResult> clusters, BlockPos pos, Vec3 currentClosestMetalObject) {
        BlockScanResult root = null;
        List<BlockPos> directions = ScanResult.getNeighbors(pos);
        for (BlockPos direction : directions) {
            root = this.tryAddToCluster(clusters, pos, direction, root);
        }
        if (root != null && currentClosestMetalObject != null && this.targetedCluster != root && root.getBlocks().contains(BlockPos.m_274446_((Position)currentClosestMetalObject))) {
            this.targetedCluster = root;
            this.hasTargetedCluster = true;
        }
        return root != null;
    }

    @Nullable
    private BlockScanResult tryAddToCluster(Map<BlockPos, BlockScanResult> clusters, BlockPos pos, BlockPos clusterPos, @Nullable BlockScanResult root) {
        BlockScanResult cluster = clusters.get(clusterPos);
        if (cluster == null) {
            return root;
        }
        if (root == null) {
            root = cluster.getRoot();
            root.add(pos);
            clusters.put(pos, root);
        } else {
            cluster.getRoot().setRoot(root);
        }
        return root;
    }

    private static List<BlockPos> getNeighbors(BlockPos start) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    neighbors.add(start.m_7918_(x, y, z));
                }
            }
        }
        return neighbors;
    }

    public Vec3 finalizeClusters() {
        this.clusterCenters = this.clusterResults.stream().map(BlockScanResult::getPosition).toList();
        if (this.hasTargetedCluster) {
            return this.targetedCluster.getPosition();
        }
        return null;
    }
}

