/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.capabilities;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.allomancy.client.metalScanning.IronSteelLinesThread;
import leaf.cosmere.allomancy.client.metalScanning.ScanResult;
import leaf.cosmere.allomancy.common.config.AllomancyConfigs;
import leaf.cosmere.allomancy.common.items.MetalVialItem;
import leaf.cosmere.allomancy.common.manifestation.AllomancyBrass;
import leaf.cosmere.allomancy.common.manifestation.AllomancyIronSteel;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.manifestation.AllomancyTin;
import leaf.cosmere.allomancy.common.manifestation.AllomancyZinc;
import leaf.cosmere.allomancy.common.registries.AllomancyItems;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.CompoundNBTHelper;
import leaf.cosmere.api.helpers.DrawHelper;
import leaf.cosmere.api.helpers.PlayerHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class AllomancySpiritwebSubmodule
implements ISpiritwebSubmodule {
    final String INGESTED_KEY = "ingested_metals";
    final String PEWTER_DELAYED_DAMAGE_KEY = "pewter_delayed_damage";
    private CompoundTag moduleTag = null;
    public final Map<Metals.MetalType, Integer> METALS_INGESTED = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> 0));
    private float pewterDelayedDamage = 0.0f;

    public static AllomancySpiritwebSubmodule getSubmodule(ISpiritweb data) {
        return (AllomancySpiritwebSubmodule)data.getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY);
    }

    public void tickClient(ISpiritweb spiritweb) {
        AllomancyZinc zinc;
        boolean zincActive;
        AllomancyBrass brass;
        boolean brassActive;
        AllomancyTin tin;
        boolean tinActive;
        AllomancyIronSteel steel;
        boolean steelActive;
        AllomancyIronSteel iron = (AllomancyIronSteel)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.IRON).get());
        boolean ironActive = iron.isActive(spiritweb);
        if (ironActive && !iron.isCompounding(spiritweb)) {
            iron.applyEffectTick(spiritweb);
        }
        if ((steelActive = (steel = (AllomancyIronSteel)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.STEEL).get())).isActive(spiritweb)) && !steel.isCompounding(spiritweb)) {
            steel.applyEffectTick(spiritweb);
        }
        if ((tinActive = (tin = (AllomancyTin)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.TIN).get())).isActive(spiritweb)) && !tin.isCompounding(spiritweb)) {
            tin.applyEffectTick(spiritweb);
        }
        if ((brassActive = (brass = (AllomancyBrass)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.BRASS).get())).isActive(spiritweb)) && !brass.isCompounding(spiritweb)) {
            brass.applyEffectTick(spiritweb);
        }
        if ((zincActive = (zinc = (AllomancyZinc)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.ZINC).get())).isActive(spiritweb)) && !zinc.isCompounding(spiritweb)) {
            zinc.applyEffectTick(spiritweb);
        }
    }

    public void tickServer(ISpiritweb spiritweb) {
        if (spiritweb.getLiving().f_19797_ % 1200 == 0) {
            for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
                Integer metalIngestAmount = this.METALS_INGESTED.get(metalType);
                if (metalIngestAmount <= 0) continue;
                this.METALS_INGESTED.put(metalType, metalIngestAmount - 1);
            }
        }
    }

    public void deserialize(ISpiritweb spiritweb) {
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        this.moduleTag = CompoundNBTHelper.getOrCreate((CompoundTag)compoundTag, (String)"allomancy");
        CompoundTag ingestedMetals = compoundTag.m_128441_("ingested_metals") ? compoundTag.m_128469_("ingested_metals") : CompoundNBTHelper.getOrCreate((CompoundTag)this.moduleTag, (String)"ingested_metals");
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            String metalKey = metalType.m_6082_();
            if (ingestedMetals.m_128441_(metalKey)) {
                int ingestedMetalAmount = ingestedMetals.m_128451_(metalKey);
                this.METALS_INGESTED.put(metalType, ingestedMetalAmount);
                continue;
            }
            this.METALS_INGESTED.put(metalType, 0);
        }
        this.pewterDelayedDamage = CompoundNBTHelper.getFloat((CompoundTag)this.moduleTag, (String)"pewter_delayed_damage", (float)0.0f);
    }

    public void serialize(ISpiritweb spiritweb) {
        CompoundTag compoundTag = spiritweb.getCompoundTag();
        this.moduleTag = CompoundNBTHelper.getOrCreate((CompoundTag)compoundTag, (String)"allomancy");
        CompoundTag ingestedMetals = new CompoundTag();
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            Integer ingestedMetalAmount = this.METALS_INGESTED.get(metalType);
            if (ingestedMetalAmount <= 0) continue;
            ingestedMetals.m_128405_(metalType.m_6082_(), ingestedMetalAmount.intValue());
        }
        if (compoundTag.m_128441_("ingested_metals")) {
            compoundTag.m_128473_("ingested_metals");
        }
        this.moduleTag.m_128365_("ingested_metals", (Tag)ingestedMetals);
        this.moduleTag.m_128350_("pewter_delayed_damage", this.pewterDelayedDamage);
        compoundTag.m_128365_("allomancy", (Tag)this.moduleTag);
    }

    public void resetOnDeath(ISpiritweb spiritweb) {
        this.pewterDelayedDamage = 0.0f;
    }

    public void drainInvestiture(ISpiritweb data, double strength) {
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            int ingestedMetalAmount = this.getIngestedMetal(metalType);
            if (ingestedMetalAmount <= 0 || !data.canTickManifestation(Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(metalType.getID()))) continue;
            int amountToAdjust = ingestedMetalAmount > 30 ? ingestedMetalAmount / 2 : ingestedMetalAmount;
            this.adjustIngestedMetal(metalType, -amountToAdjust, true);
        }
    }

    public void renderWorldEffects(ISpiritweb spiritweb, RenderLevelStageEvent event) {
        int range;
        AllomancyIronSteel ironAllomancy = (AllomancyIronSteel)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.IRON).get());
        AllomancyIronSteel steelAllomancy = (AllomancyIronSteel)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.STEEL).get());
        AllomancyTin tinAllomancy = (AllomancyTin)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.TIN).get());
        PoseStack viewModelStack = event.getPoseStack();
        if ((spiritweb.hasManifestation((Manifestation)ironAllomancy) || spiritweb.hasManifestation((Manifestation)steelAllomancy)) && (range = Math.max(ironAllomancy.getRange(spiritweb), steelAllomancy.getRange(spiritweb))) > 0) {
            Minecraft.m_91087_().m_91307_().m_6180_("cosmere-getDrawLines");
            IronSteelLinesThread.getInstance().setScanRange(range);
            ScanResult scanResult = IronSteelLinesThread.getInstance().requestScanResult();
            Vec3 closestMetalObject = IronSteelLinesThread.getInstance().getClosestMetalObject();
            Vec3 originPoint = spiritweb.getLiving().m_7371_(Minecraft.m_91087_().m_91296_()).m_82520_(0.0, -1.0, 0.0);
            Boolean drawMetalLines = (Boolean)AllomancyConfigs.CLIENT.drawMetalLines.get();
            if (drawMetalLines.booleanValue() && !scanResult.foundEntities.isEmpty()) {
                DrawHelper.drawLinesFromPoint((PoseStack)viewModelStack, (Vec3)originPoint, (float)range, (Color)Color.BLUE, scanResult.foundEntities, (Vec3)closestMetalObject);
            }
            if (drawMetalLines.booleanValue() && !scanResult.clusterResults.isEmpty()) {
                DrawHelper.drawLinesFromPoint((PoseStack)viewModelStack, (Vec3)originPoint, (float)range, (Color)Color.BLUE, scanResult.clusterCenters, (Vec3)closestMetalObject);
            }
            if (((Boolean)AllomancyConfigs.CLIENT.drawMetalBoxes.get()).booleanValue() && !scanResult.foundBlocks.isEmpty()) {
                if (scanResult.hasTargetedCluster) {
                    DrawHelper.drawBlocksAtPoint((PoseStack)viewModelStack, (Color)Color.BLUE, scanResult.foundBlocks, (float)range, (Vec3)closestMetalObject, scanResult.targetedCluster.getBlocks());
                } else {
                    DrawHelper.drawBlocksAtPoint((PoseStack)viewModelStack, (Color)Color.BLUE, scanResult.foundBlocks, (float)range, (Vec3)closestMetalObject, new ArrayList());
                }
            }
            Minecraft.m_91087_().m_91307_().m_7238_();
            IronSteelLinesThread.getInstance().releaseScanResult();
        }
        if (spiritweb.hasManifestation((Manifestation)tinAllomancy)) {
            viewModelStack.m_85850_().m_252922_().get(event.getPoseStack().m_85850_().m_252922_());
            Minecraft.m_91087_().m_91307_().m_6180_("cosmere-getDrawSoundIndicator");
            DrawHelper.drawSquareAtPoint((PoseStack)viewModelStack, (Color)Color.WHITE, AllomancyTin.getTinSoundList(), (Vec3)spiritweb.getLiving().m_146892_());
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void collectMenuInfo(List<String> m_infoText) {
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            int value = this.METALS_INGESTED.get(metalType);
            if (value <= 0) continue;
            String text = "A. " + metalType.m_6082_() + ": " + value;
            m_infoText.add(text);
        }
    }

    public void GiveStartingItem(Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)AllomancyItems.METAL_VIAL.get());
        for (int i = 0; i < 16; ++i) {
            MetalVialItem.addMetals(itemStack, i, 1);
        }
        PlayerHelper.addItem((Player)player, (ItemStack)itemStack);
    }

    public void GiveStartingItem(Player player, Manifestation manifestation) {
        if (manifestation instanceof AllomancyManifestation) {
            AllomancyManifestation allomancyManifestation = (AllomancyManifestation)manifestation;
            ItemStack itemStack = new ItemStack((ItemLike)AllomancyItems.METAL_VIAL.get());
            MetalVialItem.addMetals(itemStack, allomancyManifestation.getMetalType().getID(), 16);
            PlayerHelper.addItem((Player)player, (ItemStack)itemStack);
        }
    }

    public int getIngestedMetal(Metals.MetalType metalType) {
        return this.METALS_INGESTED.get(metalType);
    }

    public boolean adjustIngestedMetal(Metals.MetalType metalType, int amountToAdjust, boolean doAdjust) {
        int ingestedMetal = this.getIngestedMetal(metalType);
        int newValue = ingestedMetal + amountToAdjust;
        if (newValue >= 0) {
            if (doAdjust) {
                this.METALS_INGESTED.put(metalType, newValue);
            }
            return true;
        }
        return false;
    }

    public float getPewterDelayedDamage() {
        return this.pewterDelayedDamage;
    }

    public void setPewterDelayedDamage(float pewterDelayedDamage) {
        this.pewterDelayedDamage = pewterDelayedDamage;
    }
}

