/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.effects;

import leaf.cosmere.allomancy.common.capabilities.AllomancySpiritwebSubmodule;
import leaf.cosmere.allomancy.common.registries.AllomancyAttributes;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.cosmereEffect.CosmereEffect;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AllomancyBoostEffect
extends CosmereEffect {
    public AllomancyBoostEffect() {
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            if (!metalType.hasAssociatedManifestation() || !AllomancyAttributes.ALLOMANCY_ATTRIBUTES.containsKey(metalType)) continue;
            this.addAttributeModifier((Attribute)AllomancyAttributes.ALLOMANCY_ATTRIBUTES.get(metalType).get(), 0.223, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    protected int getTickOffset() {
        return Metals.MetalType.NICROSIL.getID();
    }

    public void applyEffectTick(ISpiritweb data, double strength) {
        AllomancySpiritwebSubmodule allo = AllomancySpiritwebSubmodule.getSubmodule(data);
        for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
            int ingestedMetalAmount;
            if (!metalType.hasAssociatedManifestation() || metalType == Metals.MetalType.DURALUMIN || (ingestedMetalAmount = allo.getIngestedMetal(metalType)) <= 0 || !data.canTickManifestation(Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(metalType.getID()))) continue;
            int amountToAdjust = ingestedMetalAmount > 30 ? ingestedMetalAmount / 2 : ingestedMetalAmount;
            allo.adjustIngestedMetal(metalType, -amountToAdjust, true);
        }
    }
}

