/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.eventHandlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import leaf.cosmere.allomancy.common.capabilities.world.IScadrial;
import leaf.cosmere.allomancy.common.capabilities.world.ScadrialCapability;
import leaf.cosmere.api.Constants;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="allomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AllomancyCapabilitiesHandler {
    @SubscribeEvent
    public static void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        final Level level = (Level)event.getObject();
        if (((Level)event.getObject()).m_46472_() == Level.f_46428_) {
            event.addCapability(Constants.Resources.SCADRIAL_CAP, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final ScadrialCapability scadrial;
                final LazyOptional<IScadrial> scadrialInstance;
                {
                    this.scadrial = new ScadrialCapability(level);
                    this.scadrialInstance = LazyOptional.of(() -> this.scadrial);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return cap == ScadrialCapability.CAPABILITY ? this.scadrialInstance : LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return this.scadrial.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    this.scadrial.deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && event.level.m_46472_() == Level.f_46428_) {
            MinecraftServer server = level.m_7654_();
            if (server != null && server.m_6846_().m_11309_() == 0) {
                return;
            }
            ScadrialCapability.get(level).ifPresent(iScadrial -> {});
        }
    }
}

