/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.eventHandlers;

import leaf.cosmere.allomancy.common.items.CoinPouchItem;
import leaf.cosmere.allomancy.common.manifestation.AllomancyAtium;
import leaf.cosmere.allomancy.common.manifestation.AllomancyChromium;
import leaf.cosmere.allomancy.common.manifestation.AllomancyNicrosil;
import leaf.cosmere.allomancy.common.manifestation.AllomancyPewter;
import leaf.cosmere.allomancy.common.utils.MiscHelper;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.items.MetalNuggetItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="allomancy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AllomancyEntityEventHandler {
    @SubscribeEvent
    public static void onEntityItemPickUp(EntityItemPickupEvent event) {
        if (CoinPouchItem.onPickupItem((Entity)event.getItem(), event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Item item;
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        ItemStack stack = event.getEntity().m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof MetalNuggetItem) {
            MetalNuggetItem beadItem = (MetalNuggetItem)item;
            Metals.MetalType metalType = beadItem.getMetalType();
            switch (metalType) {
                case LERASIUM: {
                    MiscHelper.consumeNugget(target, metalType, 1);
                    stack.m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Item item = event.getItem().m_41720_();
        if (item instanceof MetalNuggetItem) {
            MetalNuggetItem item2 = (MetalNuggetItem)item;
            MiscHelper.consumeNugget(livingEntity, item2.getMetalType(), 1);
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        AllomancyAtium.onLivingAttackEvent(event);
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        AllomancyNicrosil.onLivingHurtEvent(event);
        AllomancyPewter.onLivingHurtEvent(event);
        AllomancyChromium.onLivingHurtEvent(event);
    }
}

