/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import java.util.Arrays;
import java.util.List;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.registries.AllomancyManifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.eventHandlers.ModBusEventHandler;
import leaf.cosmere.common.registry.AttributesRegistry;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;

public class AllomancyBronze
extends AllomancyManifestation {
    public AllomancyBronze(Metals.MetalType metalType) {
        super(metalType);
    }

    protected void applyEffectTick(ISpiritweb data) {
        LivingEntity livingEntity = data.getLiving();
        boolean isActiveTick = this.isActiveTick(data);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)livingEntity;
            if (isActiveTick) {
                int distance = this.getRange(data);
                List entitiesToCheckForAllomancy = EntityHelper.getLivingEntitiesInRange((LivingEntity)livingEntity, (int)distance, (boolean)false);
                for (LivingEntity targetEntity : entitiesToCheckForAllomancy) {
                    if (!AllomancyBronze.isValidSeekTarget(data, targetEntity)) continue;
                    this.seekTarget(playerEntity, targetEntity);
                }
            }
        }
    }

    private void seekTarget(ServerPlayer seekerPlayer, LivingEntity targetEntity) {
        SpiritwebCapability.get((LivingEntity)targetEntity).ifPresent(targetSpiritweb -> {
            for (Manifestation manifestation : targetSpiritweb.getAvailableManifestations()) {
                if (targetEntity instanceof Player && !targetSpiritweb.canTickManifestation(manifestation)) continue;
                float pitch = Mth.m_14179_((float)((float)manifestation.getPowerID() / 16.0f), (float)0.5f, (float)2.0f);
                seekerPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12208_, SoundSource.NEUTRAL, targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_(), 64.0f, pitch, targetEntity.m_217043_().m_188505_()));
                break;
            }
        });
    }

    public static boolean isValidSeekTarget(ISpiritweb seeker, LivingEntity potentialConcealed) {
        boolean inRangeOfBronze;
        if (!Arrays.stream(ModBusEventHandler.ENTITIES_THAT_CAN_HAVE_POWERS).anyMatch(test -> test == potentialConcealed.m_6095_())) {
            return false;
        }
        AllomancyManifestation bronzeAllomancyManifestation = (AllomancyManifestation)((Object)AllomancyManifestations.ALLOMANCY_POWERS.get(Metals.MetalType.BRONZE).get());
        if (!bronzeAllomancyManifestation.isAllomanticBurn(seeker)) {
            return false;
        }
        double bronzeStrength = bronzeAllomancyManifestation.getStrength(seeker, false);
        double range = bronzeAllomancyManifestation.getRange(seeker);
        boolean bl = inRangeOfBronze = (double)seeker.getLiving().m_20270_((Entity)potentialConcealed) < range;
        if (!inRangeOfBronze) {
            return false;
        }
        AttributeMap targetAttributes = potentialConcealed.m_21204_();
        double concealmentStrength = 0.0;
        Attribute cognitiveConcealmentAttr = (Attribute)AttributesRegistry.COGNITIVE_CONCEALMENT.get();
        if (targetAttributes.m_22171_(cognitiveConcealmentAttr)) {
            concealmentStrength = targetAttributes.m_22181_(cognitiveConcealmentAttr);
        }
        return !(concealmentStrength >= bronzeStrength);
    }
}

