/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.manifestation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import leaf.cosmere.allomancy.client.AllomancyKeybindings;
import leaf.cosmere.allomancy.common.Allomancy;
import leaf.cosmere.allomancy.common.manifestation.AllomancyEntityThread;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.network.packets.EntityAllomancyActivateMessage;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.api.helpers.PlayerHelper;
import leaf.cosmere.api.math.MathHelper;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.common.config.CosmereConfigs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class AllomancyZinc
extends AllomancyManifestation {
    public static final HashMap<String, ZincThread> playerThreadMap = new HashMap();

    public AllomancyZinc(Metals.MetalType metalType) {
        super(metalType);
    }

    public void applyEffectTick(ISpiritweb data) {
        if (data.getLiving().m_9236_().m_5776_()) {
            if (this.isActiveTick(data)) {
                HitResult ray;
                boolean isSingleTarget = AllomancyKeybindings.ALLOMANCY_RIOT.m_90857_() || Keybindings.MANIFESTATION_USE_ACTIVE.m_90857_() && data.getSelectedManifestation().equals(this.getManifestation());
                int singleTargetEntityId = 0;
                if (isSingleTarget && (ray = PlayerHelper.pickWithRange((LivingEntity)data.getLiving(), (int)((int)Math.floor((double)this.getRange(data) * (Double)CosmereConfigs.SERVER_CONFIG.EMOTIONAL_POWERS_SINGLE_TARGET_RANGE_MULTIPLIER.get())))) instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)ray;
                    singleTargetEntityId = entityHitResult.m_82443_().m_19879_();
                }
                Allomancy.packetHandler().sendToServer(new EntityAllomancyActivateMessage(Metals.MetalType.ZINC, isSingleTarget, singleTargetEntityId));
            }
        } else {
            this.performEffectServer(data);
        }
    }

    private void performEffectServer(ISpiritweb data) {
        int mode = this.getMode(data);
        String uuid = data.getLiving().m_20149_();
        ZincThread playerThread = playerThreadMap.get(data.getLiving().m_20149_());
        boolean isSingleTarget = false;
        if (playerThread != null) {
            isSingleTarget = playerThread.isSingleTarget;
        }
        if (data.getLiving().m_9236_().m_7654_().m_6846_().m_11259_(data.getLiving().m_20148_()) == null) {
            return;
        }
        if (playerThreadMap.get(uuid) == null) {
            playerThreadMap.put(uuid, new ZincThread(data));
        }
        List<Object> entitiesToAffect = new ArrayList();
        if (isSingleTarget) {
            Entity entity = data.getLiving().m_9236_().m_6815_(AllomancyZinc.playerThreadMap.get((Object)uuid).singleTargetEntityID);
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                entitiesToAffect.add(entity2);
            }
        } else {
            entitiesToAffect = playerThreadMap.get(uuid).requestEntityList();
        }
        for (LivingEntity livingEntity : entitiesToAffect) {
            if (!(livingEntity instanceof Mob)) continue;
            Mob mob = (Mob)livingEntity;
            mob.m_21557_(false);
            switch (mode) {
                case 3: {
                    if (mob.m_5448_() == null) {
                        LivingEntity attackTarget = (LivingEntity)entitiesToAffect.get(MathHelper.RANDOM.nextInt(entitiesToAffect.size()));
                        mob.m_6710_(attackTarget);
                    }
                }
                case 2: {
                    if (mob.m_21188_() != null) break;
                    mob.m_6703_(mob.m_5448_() != null ? mob.m_5448_() : (LivingEntity)entitiesToAffect.get(MathHelper.RANDOM.nextInt(entitiesToAffect.size())));
                }
            }
            mob.m_21561_(true);
        }
        if (!isSingleTarget) {
            playerThreadMap.get(uuid).releaseEntityList();
        }
    }

    @Override
    public void onModeChange(ISpiritweb data, int lastMode) {
        String uuid = data.getLiving().m_20149_();
        if (this.getMode(data) <= 0) {
            playerThreadMap.remove(uuid);
        }
        super.onModeChange(data, lastMode);
    }

    @Override
    public boolean tick(ISpiritweb data) {
        String uuid = data.getLiving().m_20149_();
        if (!playerThreadMap.containsKey(uuid)) {
            playerThreadMap.put(uuid, new ZincThread(data));
        }
        playerThreadMap.entrySet().removeIf(entry -> !((ZincThread)entry.getValue()).isRunning || AllomancyEntityThread.serverShutdown || entry.getValue() == null);
        return super.tick(data);
    }

    public class ZincThread
    extends AllomancyEntityThread {
        public boolean isSingleTarget;
        public int singleTargetEntityID;

        public ZincThread(ISpiritweb data) {
            super(data);
            this.isSingleTarget = false;
            this.singleTargetEntityID = 0;
            Thread t = new Thread((Runnable)this, "zinc_thread_" + data.getLiving().m_5446_().getString());
            t.start();
        }

        @Override
        public void run() {
            while (true) {
                int mode = AllomancyZinc.this.getMode(this.data);
                if (serverShutdown || mode <= 0) break;
                try {
                    if (lock.tryLock()) {
                        int range = AllomancyZinc.this.getRange(this.data);
                        List newEntityList = EntityHelper.getLivingEntitiesInRange((LivingEntity)this.data.getLiving(), (int)range, (boolean)true);
                        this.setEntityList(newEntityList);
                        lock.unlock();
                    }
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    CosmereAPI.logger.debug(Arrays.toString(e.getStackTrace()));
                    if (!(e instanceof ConcurrentModificationException)) break;
                    lock.unlock();
                    break;
                }
            }
            this.isRunning = false;
        }
    }
}

