/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.recipes;

import java.util.Optional;
import javax.annotation.Nonnull;
import leaf.cosmere.allomancy.common.Allomancy;
import leaf.cosmere.allomancy.common.items.MetalVialItem;
import leaf.cosmere.allomancy.common.registries.AllomancyItems;
import leaf.cosmere.allomancy.common.registries.AllomancyRecipes;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class VialMixingRecipe
extends CustomRecipe {
    private static final Ingredient INGREDIENT_BOTTLE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_, (ItemLike)AllomancyItems.METAL_VIAL.get()});

    public VialMixingRecipe(ResourceLocation loc, CraftingBookCategory pCategory) {
        super(loc, pCategory);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        boolean hasNugget = false;
        ItemStack vialStack = null;
        int bottleAmount = 0;
        int nuggetTotal = 0;
        MetalVialItem metalVialItem = (MetalVialItem)((Object)AllomancyItems.METAL_VIAL.get());
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (INGREDIENT_BOTTLE.test(stack)) {
                if (vialStack != null) {
                    return false;
                }
                vialStack = stack;
                if (!vialStack.m_150930_((Item)metalVialItem)) continue;
                bottleAmount = MetalVialItem.containedMetalCount(vialStack);
                continue;
            }
            if (this.testForViableNugget(stack).isPresent()) {
                hasNugget = true;
                ++nuggetTotal;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        if (vialStack == null) {
            return false;
        }
        if (bottleAmount + nuggetTotal > MetalVialItem.getMaxFillCount(vialStack)) {
            return false;
        }
        if (vialStack.m_41720_() == AllomancyItems.METAL_VIAL.get()) {
            return hasNugget && !MetalVialItem.isFull(vialStack);
        }
        return hasNugget;
    }

    private Optional<TagKey<Item>> testForViableNugget(ItemStack stack) {
        for (Metals.MetalType value : EnumUtils.METAL_TYPES) {
            TagKey metalNuggetTag = value.getMetalNuggetTag();
            if (!stack.m_204117_(metalNuggetTag)) continue;
            return Optional.of(metalNuggetTag);
        }
        return Optional.empty();
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        MetalVialItem metalVial = (MetalVialItem)((Object)AllomancyItems.METAL_VIAL.get());
        ItemStack itemstack = new ItemStack((ItemLike)metalVial);
        block0: for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_204117_(Tags.Items.NUGGETS)) {
                for (Metals.MetalType metalType : EnumUtils.METAL_TYPES) {
                    if (!stackInSlot.m_204117_(metalType.getMetalNuggetTag())) continue;
                    MetalVialItem.addMetals(itemstack, metalType.getID(), 1);
                    continue block0;
                }
                continue;
            }
            if (!stackInSlot.m_150930_((Item)metalVial)) continue;
            MetalVialItem.addMetals(itemstack, stackInSlot);
        }
        return itemstack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return Allomancy.rl("vial_mix");
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AllomancyRecipes.VIAL_MIX.get();
    }
}

