/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.allomancy.common.registries;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.allomancy.common.manifestation.AllomancyAluminum;
import leaf.cosmere.allomancy.common.manifestation.AllomancyAtium;
import leaf.cosmere.allomancy.common.manifestation.AllomancyBendalloy;
import leaf.cosmere.allomancy.common.manifestation.AllomancyBrass;
import leaf.cosmere.allomancy.common.manifestation.AllomancyBronze;
import leaf.cosmere.allomancy.common.manifestation.AllomancyCadmium;
import leaf.cosmere.allomancy.common.manifestation.AllomancyChromium;
import leaf.cosmere.allomancy.common.manifestation.AllomancyCopper;
import leaf.cosmere.allomancy.common.manifestation.AllomancyDuralumin;
import leaf.cosmere.allomancy.common.manifestation.AllomancyElectrum;
import leaf.cosmere.allomancy.common.manifestation.AllomancyGold;
import leaf.cosmere.allomancy.common.manifestation.AllomancyIronSteel;
import leaf.cosmere.allomancy.common.manifestation.AllomancyMalatium;
import leaf.cosmere.allomancy.common.manifestation.AllomancyManifestation;
import leaf.cosmere.allomancy.common.manifestation.AllomancyNicrosil;
import leaf.cosmere.allomancy.common.manifestation.AllomancyPewter;
import leaf.cosmere.allomancy.common.manifestation.AllomancyTin;
import leaf.cosmere.allomancy.common.manifestation.AllomancyZinc;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.registration.impl.ManifestationDeferredRegister;
import leaf.cosmere.common.registration.impl.ManifestationRegistryObject;

public class AllomancyManifestations {
    public static final ManifestationDeferredRegister MANIFESTATIONS = new ManifestationDeferredRegister("allomancy");
    public static final Map<Metals.MetalType, ManifestationRegistryObject<AllomancyManifestation>> ALLOMANCY_POWERS = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasAssociatedManifestation).collect(Collectors.toMap(Function.identity(), metalType -> MANIFESTATIONS.register(metalType.m_6082_(), () -> AllomancyManifestations.makeAllomancyManifestation(metalType))));

    private static AllomancyManifestation makeAllomancyManifestation(Metals.MetalType metalType) {
        switch (metalType) {
            case IRON: 
            case STEEL: {
                return new AllomancyIronSteel(metalType);
            }
            case TIN: {
                return new AllomancyTin(metalType);
            }
            case PEWTER: {
                return new AllomancyPewter(metalType);
            }
            case ZINC: {
                return new AllomancyZinc(metalType);
            }
            case BRASS: {
                return new AllomancyBrass(metalType);
            }
            case COPPER: {
                return new AllomancyCopper(metalType);
            }
            case BRONZE: {
                return new AllomancyBronze(metalType);
            }
            case ALUMINUM: {
                return new AllomancyAluminum(metalType);
            }
            case DURALUMIN: {
                return new AllomancyDuralumin(metalType);
            }
            case CHROMIUM: {
                return new AllomancyChromium(metalType);
            }
            case NICROSIL: {
                return new AllomancyNicrosil(metalType);
            }
            case CADMIUM: {
                return new AllomancyCadmium(metalType);
            }
            case BENDALLOY: {
                return new AllomancyBendalloy(metalType);
            }
            case GOLD: {
                return new AllomancyGold(metalType);
            }
            case ELECTRUM: {
                return new AllomancyElectrum(metalType);
            }
            case ATIUM: {
                return new AllomancyAtium(metalType);
            }
            case MALATIUM: {
                return new AllomancyMalatium(metalType);
            }
        }
        return new AllomancyManifestation(metalType);
    }
}

